/*
  ==============================================================================

    LineGraph.h
    Created: 17 Sep 2016 11:13:25pm
    Author:  studioone

  ==============================================================================
*/

#ifndef LINEGRAPH_H_INCLUDED
#define LINEGRAPH_H_INCLUDED

#include "JuceHeader.h"
#include <array>

//==============================================================================
/*
*/
class LineGraph    : public Component,
                    private Button::Listener
{
public:
    LineGraph();
    ~LineGraph();

    void paint (Graphics&) override;
    void resized() override;
   void mouseEnter (const MouseEvent&) override;
    void mouseExit (const MouseEvent&) override;
    void mouseDrag (const MouseEvent&) override;
    void mouseUp (const MouseEvent&) override;
    void mouseDown (const MouseEvent&) override;
    void mouseDoubleClick (const MouseEvent&) override;
    
    
    
    void recalcGraphMap();
    
    
    
    static const int numInputValues = 210;
    static const int numOutputValues = 128;
    
    std::array<int, numInputValues+1> graphMap;
    
    int numNodes = 5;
    
    static const int maxNumNodes = 10;
    std::array<Point<float>, maxNumNodes+1> nodeArray;//array is one bigger to allow for out of bounds

private:
    
    //methods
    void buttonClicked (Button* but) override;
    int clickInNode (int x, int y);

    
    //vars
    int getRealX(int mouseX);
    int getRealY(int mouseY);
    
    //TooltipWindow graphTips;
    
    TextButton invertBut;
    TextButton flipBut;
    TextButton resetBut;
    
    Label posLabel;

    int graphWidth;
    int nodeRad;
    Rectangle<int> graphRect;
    
    void invert();
    void flip();
    void reset();
    
    bool activeNode;
    bool dragisMD = false;
   // int lastIndex;
    //float mouseXproportion;
    //float mouseYproportion;
    float widthscale;
    float heightscale;
    int currentNode;
    
   
    
    
    
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (LineGraph)
};


#endif  // LINEGRAPH_H_INCLUDED
