/*
  ==============================================================================

    myManta.h
    Created: 8 Apr 2016 10:07:58pm
    Author:  Studio One

  ==============================================================================
*/

#ifndef MYMANTA_H_INCLUDED
#define MYMANTA_H_INCLUDED
#include "core/Manta.h"
#include "MantaData.h"
#include "MidiIO.h"
#include "core/MantaExceptions.h"

#include "JuceHeader.h"
class MainContentComponent;//forward declaration

class MyManta   : public Manta,
                  public Thread

{
public:
    //==============================================================================
    MyManta();
    
    ~MyManta();

    void run() override;//does run need to be public?
    bool isConnected = false;
    
    MantaData theData;
    MidiIO theMidiIO;
    MainContentComponent* mainComponent;
    
    //bool multiChanMode;
    
    void panic();
    

private:
    bool eventJustHappened = false;
    
    std::array<int, 50> padChannels; //which channel is used by each pad
    std::array<int, 18> channelPads; //which pad is active on each channel
    
    std::array<int, 50> * ledArray;//pointer to whichever one is active

    
    //METHODS
    void PadEvent(int row, int column, int padnum, int value) override;
    void PadVelocityEvent(int row, int column, int padnum, int velocity) override;
    void SliderEvent(int index, int value) override;
    void ButtonVelocityEvent(int index, int velocity) override;
    
    
    
    void noteOn(int note, int pad, int vel);
    void noteOff(int note, int pad, int vel);
    
    void noteOnLeg(int note, int pad, int vel);
    void noteOffLeg(int note, int pad, int vel);
    
    void noteOnRetrig(int note, int pad, int vel);
    void noteOffRetrig(int note, int pad, int vel);
    
    void sendCC(int pad, int chan);
    
    void handleNoteOnOff(int note, int pad, int vel, bool isNoteOn);
    
    int getNextChannel();
    int lastChannel = 1;
    
    int getMaxPadPressure();
    
    int currentpad = 0;
    
    int maxPressure;//stores max pad coverage RAW so int 1-210
    float maxMappedPressure;//stores max actual mapped pressure value, which might map to a low output value on an inverted graph
    //is this used?
    
    //const float onestepin= 1/210;//is it actually 210? or 209 steps 210values?
    //const float onestep7bit=1/127; //127steps has 128values, (gaps and posts)
    
    void SetPadLED(int colour, int pad);
    //void setLEDsFromNotes();
    void setLEDs(int padCode);
    
    void onExit();
    void onRun();
    
    //THIS IS TEMPOARY WORKING FOR theManta so moved from theData
    std::array<int, 50> padValues;//stores last pressure/coverage value
    std::array<int, 50> lastSentVal;//stores last sent actual message value
    
    //==============================================================================
    //JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (MyManta)
    //would need to include juce for this
};



#endif  // MYMANTA_H_INCLUDED
