/*
  ==============================================================================

    myManta.cpp
    Created: 8 Apr 2016 10:07:41pm
    Author:  Studio One

  ==============================================================================
*/
//#include "Manta.h"
#include "MyManta.h"
#include "MainComponent.h"
//#import "MantaExceptions.h"
#include <algorithm>
#include<iostream>//enables c standard output
using namespace std;
//can i use the mymanta namespace??

MyManta::MyManta()
: Thread ("MyMantaThread")
{
    //setLEDsFromArray();//lededitor may not be constructed yet??
    
    //std::fill_n(padChannels, 50, -1);
    //std::fill_n(channelPads, 16, -1);
    //MainContentComponent* mainComponent = mainComponentPtr;
    padValues.fill(0);
    theData.exprOut = &theMidiIO.expOut;

    cout << "themanta constructed  \n";
}


MyManta::~MyManta()
{
    
}

void MyManta::run()
{
    onRun();
    int longPollInterval = 5;
    while (! threadShouldExit())
    {
        
        
        
        try
        {
            HandleEvents();
        }
        catch (MantaCommunicationException)
        {
            cout << "MantaCommunicationException" << endl;
            //send a message to gui to set button off
            signalThreadShouldExit();
            const MessageManagerLock mmLock;//calling gui thread from manta thread so have to lock it!
            mainComponent->mantaDisconnected();

        }
        
        
        if (eventJustHappened)
            wait(theData.pollInterval);
        else
        {
            wait(longPollInterval);
            eventJustHappened = false;
        };
        
//////led section ////
        
        if ((theData.ledMessagePending != -1))
        {
            
            int padCode = -2;
            if (theData.arbNoteMode)
            {
                ledArray = &theData.theArbEditor.ledArray;
                //cout << "setLEDs arb - padcode = " <<padCode<<" \n";
            }
            else if (!theData.arbNoteMode)
            {
                ledArray = &theData.theIsoEditor.ledArray;
                //cout << "setLEDs iso - padcode = " <<padCode<<" \n";
            }
            padCode = theData.ledMessagePending;

            theData.ledMessagePending = -1;
            //theData.theArbEditor.ledMessagePending = -1;

            
            //cout << "setLEDs padCode = " <<padCode<<" \n";
            
            
            Manta::SetLEDControl(PadAndButton, true);
            
            switch(*theData.redAndYellowLEDs)
            {
                case 0://both
                {
                    setLEDs(padCode);
                }
                    break;
                case 1://redonly
                {
                    
                    setLEDs(padCode);
                    Manta::SetLEDControl(PadAndButton, false);
                }
                    break;
                case 2://off
                {
                    Manta::ClearPadAndButtonLEDs();
                    Manta::SetLEDControl(PadAndButton, false);
                }
                    break;
                default:
                    throw std::invalid_argument("invalid ledsetting Mode");
            }//end switch
            Manta::SetLEDControl(PadAndButton, true);//HUH?? doesn't this undo sometimes turning it off above?
        };//end led section
        
        
        
        //cout << "still running  " << Time::getMillisecondCounterHiRes() << "\n";
    }
    onExit();
}

void MyManta::setLEDs(int padCode)
{
    
    if (padCode == 50)
    {
        //cout << "led full reset starting  \n";
        
        int colourindex = -1;
        for (int i = 0; i < 48; ++i)
        {
            colourindex = (*ledArray)[i];
            if ((*theData.redAndYellowLEDs == 1) && (colourindex == 1))
                colourindex = 0;//set yellow to off if red only is allowed to avoid flickering
            SetPadLED(colourindex, i);
            //cout << "pad = " <<i<< " colour = " << colourindex <<" \n";
        };
        //cout << "setLEDsFromArray completed  \n";
        
    }
    else if (padCode >= 0)
    {
        SetPadLED((*ledArray)[padCode], padCode);
    };
    
}

void MyManta::SetPadLED(int colour, int pad)
{
    
    //cout << "setpadled " << pad << " value " << colour <<" \n";
    
    switch(colour)
    {
        case 0:
            Manta::SetPadLED(Off, pad);//translate integer colour codes to enum colours
            break;
        case 1:
            Manta::SetPadLED(Amber, pad);//translate integer colour codes to enum colours
            break;
        case 2:
            Manta::SetPadLED(Red, pad);//translate integer colour codes to enum colours
            break;
        default:
            cout << "invalid led value = " << colour <<" pad = " << pad <<" \n";
            throw std::invalid_argument("Invalid int led colour code");
    }
}

void MyManta::onExit()
{
    cout << "exiting thread  \n";
    Manta::SetLEDControl(PadAndButton, true);

    Manta::ClearPadAndButtonLEDs();
    
    try//one last call to clear leds
    {
        HandleEvents();
        cout << "should have cleared leds \n";
    }
    catch (MantaCommunicationException)
    {
        cout << "MantaCommunicationException" << endl;
    }
    
    Manta::Disconnect();
    
}

void MyManta::onRun()
{
    cout << "running  \n";
    //setLEDsFromArray();
}

void MyManta::panic()
{
	padValues.fill(0);
	lastSentVal.fill(0);
	
	//put allnotesoff in here?
    //cout << "sent all notes off so DON'T PANIC (much)\n";
    //setLEDsFromArray();
}

int MyManta::getNextChannel()//direct transliteration from mantrid
{
    int newChannel;
    int channelCheck = ((lastChannel) % (theData.numMultiChannels)+1);
    //cout << "channelCheck = " <<channelCheck << " \n";
    int count  = 1;
    while ((channelPads[channelCheck] != 0) && (count <= theData.numMultiChannels))
    {
        channelCheck = ((channelCheck) % (theData.numMultiChannels)+1);
        //cout << "channelCheck = " <<channelCheck << " \n";
        //cout << "channelPads[channelCheck] = " <<channelPads[channelCheck] << " \n";

        ++count;
    }
    if (count <= theData.numMultiChannels)
    {
        newChannel = channelCheck;
    } else {//steal note
        newChannel = channelCheck; // steal it anyway
        // now send note off for stolen note
        int pad = channelPads[newChannel];
        int notenum = (*theData.padToNoteMap)[pad];
        noteOff(notenum, pad, 0);
        lastSentVal[pad] = 0;
        //cout << "stole a note on channel " << newChannel << " \n";
        padChannels[pad] = 0;
        channelPads[newChannel] = 0;//not needed, about to start new note on this channel anyway?
    }
    //cout << "lastChannel = " <<lastChannel << " \n";
    //cout << "newChannel = " <<newChannel << " \n";
    lastChannel = newChannel;
    return newChannel;
    
}

int MyManta::getMaxPadPressure()
{
    float maxPressRaw = 0;
    for (int i = 0; i < 50; ++i)
    {
        if (padValues[i] > maxPressRaw)
            maxPressRaw = padValues[i];
    };
    
    return maxPressRaw;//this is an unmapped value
}

void MyManta::noteOn(int note, int pad, int vel)
{
    if (theData.expressionMode == 3)
    {
        //handle channels
        int newChannel = getNextChannel();
        theMidiIO.sendNoteOn(newChannel, note, vel);
        padChannels[pad] = newChannel;
        channelPads[newChannel] = pad;
    } else {
        theMidiIO.sendNoteOn(theData.channel, note, vel);//vel is already mapped!
    }
}

void MyManta::noteOff(int note, int pad, int vel)
{
    if ((theData.expressionMode == 3)&&(padChannels[pad] != 0))
    {
        //handle channels
        int channel = padChannels[pad];
        theMidiIO.sendNoteOff(channel, note, vel);
        padChannels[pad] = 0;
        channelPads[channel] = 0;//release the channel
    } else
{
        theMidiIO.sendNoteOff(theData.channel, note, 0);
    }

}


void MyManta::noteOnLeg(int note, int pad, int vel)
{
		noteOn(note, pad, vel);
		int lastpad=theData.notesDown.getLast();
		if (lastpad > 0){
			
			//cout << "noteOnLeg - now stopping"  << lastpad << " \n";
			noteOff((*theData.padToNoteMap)[lastpad], lastpad, 0);
		}
		theData.notesDown.add(pad);
		
		//cout << "notesDown = "  << " \n";
		    //~ for (int i = 0; i < theData.notesDown.size(); ++i)
				//~ {
					//~ cout << theData.notesDown[i] << "-";
				//~ };
				
				//~ cout << "endnotesDown"  << " \n";
}

void MyManta::noteOffLeg(int note, int pad, int vel)
{
			bool isplaying;
			if (pad == currentpad) isplaying = true;
			//theData.notesDown.removeAllInstancesOf(pad);//why not removeFirstMatchingValue ??
			theData.notesDown.removeFirstMatchingValue(pad);
			
			//start next note in line if there is one
			int lastpad=theData.notesDown.getLast();
			if (lastpad > 0 && lastpad != currentpad){
				
				//cout << "noteOffLeg - now starting"  << lastpad << " \n";
				noteOn((*theData.padToNoteMap)[lastpad], lastpad, padValues[pad]);//uses latest padvalue as vel
				currentpad=lastpad;
			}	
			if (isplaying) noteOff(note, pad, vel);	
}




void MyManta::noteOnRetrig(int note, int pad, int vel)
{
		int lastpad=theData.notesDown.getLast();
		if (lastpad > 0) noteOff((*theData.padToNoteMap)[lastpad], lastpad, 0);
		noteOn(note, pad, vel);
		theData.notesDown.add(pad);
}

void MyManta::noteOffRetrig(int note, int pad, int vel)
{
		//don't turn the note off unless it is actually on.
		if (pad == currentpad) noteOff(note, pad, vel);
		theData.notesDown.removeFirstMatchingValue(pad);
		//start next note in line if there is one
		int lastpad=theData.notesDown.getLast();
		if (lastpad > 0 && lastpad != currentpad){
			noteOn((*theData.padToNoteMap)[lastpad], lastpad, padValues[pad]);//uses latest padvalue as vel
			currentpad=lastpad;
		}
		
}

void MyManta::sendCC(int pad, int chan)
{
		float hires;
		if (theData.polyMono == 1 && theData.expressionMode == 2){
			hires = (*theData.pressMap)[maxPressure]*127;
		} else {
			hires = (*theData.pressMap)[padValues[pad]]*127;
		}
		
		
		int msb = (int)hires;
	
		if (theData.ccToUse == -1)//channel pressure
		{
			theMidiIO.sendChannelPressure(chan, msb);
			lastSentVal[pad] = msb;
		}
		else
		{// normal CC
			if (theData.hirescc)
			{
				int lsb = (hires-msb)*127;

				theMidiIO.sendContControllerHiRes(chan, theData.ccToUse, msb, lsb);
				lastSentVal[pad] = hires;
			}
			else
			{
				theMidiIO.sendContController(chan, theData.ccToUse, msb);
				lastSentVal[pad] = msb;
			}				
		}
	
	
	
}
void MyManta::handleNoteOnOff(int note, int pad, int vel, bool isNoteOn){
	switch(theData.polyMono)
			{
            case 1:////polyphonic
				if (isNoteOn){
					noteOn(note, pad, vel);
				} else {
					noteOff(note, pad, vel);
				}
                break;
            case 2://legato
                if (isNoteOn){
					noteOnLeg(note, pad, vel);
				} else {
					noteOffLeg(note, pad, vel);
				}//legato
                break;
            case 3://retrig
                if (isNoteOn){
					noteOnRetrig(note, pad, vel);
				} else {
					noteOffRetrig(note, pad, vel);
				}//retrigger
                break;
            default:
                throw std::invalid_argument("polymono mode fuckup");
			}
}

/////////////////////////////////////////////////////////////////////////////////
////////////////////////////// THE MAIN EVENT ///////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////

void MyManta::PadEvent(int row, int column, int padnum, int value)
{
    //cout << "PAD = " << padnum <<" value = " << value << " \n";
    eventJustHappened = true;
     
    
	float velfl = 1;//BONKERS
    
    if (theData.fastVel)//only send noteon and off if fastvel
    {
		velfl=1+(*theData.pressMap)[value]*126;
        if (padValues[padnum] == 0)//pad is turning on
        {	
			handleNoteOnOff((*theData.padToNoteMap)[padnum], padnum, (int)velfl, true);
			currentpad=padnum;
        } else if (value == 0){
            handleNoteOnOff((*theData.padToNoteMap)[padnum], padnum, (int)velfl, false);//pad is turning off 
        }
    }
    //now send pressure for the pad value
    
	float hires = (*theData.pressMap)[value]*127;
	//~ //int rounded = 0.5+hires;
	//~ int msb = (int)hires;
	//~ int lsb = (hires-msb)*127;
//CHECK behaviour with artificial stable input pad values - is manta sending +/-1 padvalues or is this code creating them?

    if (abs(hires-lastSentVal[padnum]) >= theData.thin)
    {
        switch (theData.expressionMode)
        {
            case 1://polyafter
            {
				int msb = (int)hires;
                theMidiIO.sendPolyAfter(theData.channel, (*theData.padToNoteMap)[padnum], msb);
                lastSentVal[padnum] = msb;
            }
                break;
            case 2://CC
            {//LOTS OF CODE REPETITION HERE!
				
				if (theData.polyMono > 1 ){//mono mode
					//if ( currentpad==padnum){
					//int currentpad = theData.notesDown.getLast();//OPTIMISE THIS
					sendCC(currentpad, theData.channel);
					//~ hires = (*theData.pressMap)[padValues[currentpad]]*127;
					//~ int msb = (int)hires;
				
					//~ if (theData.ccToUse == -1)//channel pressure
						//~ {
						//~ theMidiIO.sendChannelPressure(theData.channel, msb);
						//~ lastSentVal[currentpad] = msb;
					//~ }
					//~ else
					//~ {// normal CC
						//~ if (theData.hirescc)
						//~ {
							//~ int lsb = (hires-msb)*127;

							//~ theMidiIO.sendContControllerHiRes(theData.channel, theData.ccToUse, msb, lsb);
							//~ lastSentVal[currentpad] = hires;
						//~ }
						//~ else
						//~ {
							//~ theMidiIO.sendContController(theData.channel, theData.ccToUse, msb);
							//~ lastSentVal[currentpad] = msb;
						//~ }				
					//~ }
					//}//end if currentpad
					
					
				} else {//start poly mode
					
					if (value >= maxPressure)//this compares UNmapped values
					{
						maxPressure = value;
						//cout << "maxPressure from pad" << maxPressure << " \n";
					}
					else
					{
						maxPressure = getMaxPadPressure() ;//get max value from array of other pads currently down and
					//arg this sends the mapped value corresponding to the raw max, not the actual max if map is inverted - is that ok??(same as mantrid tho)
						//cout << "maxPressure from array" << maxPressure << " \n";
					};
					sendCC(0, theData.channel);//doesnt even need to know the pad as is channel CC
					///cout << "maxPressure = " <<maxPressure << " \n";
					
					////ARG have to calc this again!! FIX
					//~ float maxhires = (*theData.pressMap)[maxPressure]*127;
					//~ int maxmsb = (int)maxhires;
					//~ int maxlsb = (hires-maxmsb)*127;
					
					//~ if (theData.ccToUse == -1)//channel pressure is not a normal CC
					//~ {
						//~ theMidiIO.sendChannelPressure(theData.channel, maxmsb);
						//~ lastSentVal[padnum] = maxmsb;
					//~ }
					//~ else//must be a normal CC
					//~ {
						//~ if (theData.hirescc)
						//~ {
							//~ theMidiIO.sendContControllerHiRes(theData.channel, theData.ccToUse, maxmsb,maxlsb);
							//~ lastSentVal[padnum] = maxhires;
						//~ }
						//~ else
						//~ {
						//~ theMidiIO.sendContController(theData.channel, theData.ccToUse, maxmsb);
						//~ lastSentVal[padnum] = maxmsb;
						//~ }
					//~ }
					
				}//end poly mode
            }
                break;
            case 3://multimode
            {
				//int msb = (int)hires;
                int chan = padChannels[padnum];
                //(happens when note turns off)
                if (chan != 0)
                {      
					sendCC(padnum, chan);              
					//~ if (theData.ccToUse == -1)
					//~ {
						//~ theMidiIO.sendChannelPressure(chan, msb);
						//~ lastSentVal[padnum] = msb;
					//~ }
					//~ else
					//~ {
						//~ if (theData.hirescc)
						//~ {
							//~ int lsb = (hires-msb)*127;
							//~ //cout << " hires = " << hires << " msb = " << msb << " lsb = " << lsb <<" \n";
							//~ //cout <<  " msb = " << msb << " \n";
							//~ theMidiIO.sendContControllerHiRes(chan, theData.ccToUse, msb, lsb);
							//~ lastSentVal[padnum] = hires;
						//~ }
						//~ else
						//~ {
							//~ theMidiIO.sendContController(chan, theData.ccToUse, msb);
							//~ lastSentVal[padnum] = msb;
						//~ }				
					//~ }
				//cout << "chan = " << chan <<" \n";		
				}
            }
                break;
            case 4://off
                break;
            default:
                throw std::invalid_argument("Invalid expressionmode");
        }
       // padValues[padnum] = value; //stores raw manta values not mapped ones //only stores values that resulted in a sent message...
    }
     padValues[padnum] = value; //stores raw manta values not mapped ones //sends all values even if thinned out

}//////////////////////  END PADEVENT  /////////////////////

void MyManta::PadVelocityEvent(int row, int column, int padnum, int velocity)
{
    //eventJustHappened = true;//not needed as will be triggerred by padevent always?
    if ( !theData.fastVel )
    {
        if (velocity > 0)//this returns a midi velocity 0-127 (i think?)
            handleNoteOnOff((*theData.padToNoteMap)[padnum], padnum, velocity, true);
        else
        {
            handleNoteOnOff((*theData.padToNoteMap)[padnum], padnum, velocity, false);
        cout << "NOTEOFF from Vel padnum = " << padnum << " \n";
		}
    }
    
}

void MyManta::SliderEvent(int index, int value)
{
    eventJustHappened = true;
    int cc;
    int divi = 32;
    if (theData.slider1CC == 5){
		divi = 64;
		cout << "porta change" << divi << " " << value << " \n";
	}
    if (value < 4096){
        cc = value/divi;
        switch(index)
        {
            case 0:
                theMidiIO.sendContController(theData.channel, theData.slider0CC, cc);
                break;
            case 1:
                theMidiIO.sendContController(theData.channel, theData.slider1CC, cc);
                break;
            default:
                throw std::invalid_argument("Invalid slider");
        }
        //cout << "slider " << index << " value = " << value << " \n";
    }
    
    
   
}

void MyManta::ButtonVelocityEvent(int index, int velocity)
{
    eventJustHappened = true;
    if (velocity > 0) // don't want the release event
    {
        switch(index)
        {
            case 0:
                theData.transpose(-12);
                break;
            case 1:
                theData.transpose(12);
                break;
            case 2:
                theData.transpose(-1);
                break;
            case 3:
                theData.transpose(1);
                break;
            default:
                throw std::invalid_argument("Invalid button");
        }
    }
    
    //cout << "button " << index << " value = " << velocity << " \n";
}


