/*
  ==============================================================================

    MidiIO.h
    Created: 16 Apr 2016 10:57:10pm
    Author:  Studio One

  ==============================================================================
*/

#ifndef MIDIIO_H_INCLUDED
#define MIDIIO_H_INCLUDED

#include "JuceHeader.h"

class MidiIO //: //private MidiInputCallback
{
    
public:
    //methods
    MidiIO();
    ~MidiIO();
    void panicButton();
    void makeMainOut();
    void makeExpOut();
    void sendNoteOn(int channel, int note, int vel);
    void sendNoteOff(int channel, int note, int vel);
    void sendPolyAfter(int channel, int note, int value);
    void sendChannelPressure(int channel, int value);
    void sendContController(int channel, int type, int value);
    void sendContControllerHiRes(int channel, int type, int msb, int lsb);
    
    //void setMidiOutput (int index);
    //void setMidiInput (int index);
    
    ///variables etc
    int lastInputIndex;
    
    bool expOut = false;//needs to link with expOut in theData how?
    
private:
    AudioDeviceManager deviceManager;
    MidiOutput *mainOutput;
    MidiOutput *expOutput;
    //void handleIncomingMidiMessage (MidiInput* source, const MidiMessage& message) override;
    
};

#endif  // MIDIIO_H_INCLUDED

