/*
  ==============================================================================

    MidiIO.cpp
    Created: 16 Apr 2016 10:57:10pm
    Author:  Studio One

  ==============================================================================
*/

#include "MidiIO.h"

#include<iostream>//enables c standard output
using namespace std;

MidiIO::MidiIO()
{
    makeMainOut();
    makeExpOut();
    
};

MidiIO::~MidiIO()
{
    //deviceManager.removeMidiInputCallback (MidiInput::getDevices()[midiInputList.getSelectedItemIndex()], this);
    if (mainOutput != 0)
        delete mainOutput;
        
    if (expOutput != 0)
        delete expOutput;
};

void MidiIO::panicButton()//SEND ON ALL CHANNELS
{
    
    for (int chan = 1; chan <= 16; chan++)
    {
        MidiMessage newmessage = MidiMessage::allNotesOff(chan);
        mainOutput->sendMessageNow(newmessage);
        
    }
    
    
}

void MidiIO::makeMainOut()
{
    
    delete mainOutput; //close old output // is this needed?
    
   
        //create virtual midi out
        mainOutput = MidiOutput::createNewDevice ("MantaMainOut");
        if (mainOutput != nullptr)
        {
            deviceManager.setDefaultMidiOutput("MantaMainOut");//what does default do anyway?
            cout << "created MantaOut main out \n";
        }
        else
            cout << "failed to create main out \n";
        
    
}

void MidiIO::makeExpOut()
{
    
    delete expOutput; //close old output // is this needed?
    
   
        //create virtual midi out
        expOutput = MidiOutput::createNewDevice ("MantaExpOut");
        if (expOutput != nullptr)
        {
            //deviceManager.setDefaultMidiOutput("MantaExpOut");//what does default do anyway?
            cout << "created MantaOut exp out \n";
        }
        else
            cout << "failed to create exp out \n";
        
    
}

void MidiIO::sendContController(int channel, int number, int val)
{
    MidiMessage newmessage = MidiMessage::controllerEvent(channel, number, val);
    if (expOut){
		    expOutput->sendMessageNow(newmessage);

	}else{
		    mainOutput->sendMessageNow(newmessage);

	}
}

void MidiIO::sendContControllerHiRes(int channel, int number, int msb, int lsb)
{
    MidiMessage msbmessage = MidiMessage::controllerEvent(channel, number, msb);
    MidiMessage lsbmessage = MidiMessage::controllerEvent(channel, number+32, lsb);
    if (expOut){
		expOutput->sendMessageNow(msbmessage);
		expOutput->sendMessageNow(lsbmessage);

	}else{
		mainOutput->sendMessageNow(msbmessage);
		mainOutput->sendMessageNow(lsbmessage);
	}

}

void MidiIO::sendNoteOn(int channel, int note, int vel)
{
    MidiMessage newmessage = MidiMessage::noteOn(channel, note, (uint8)vel) ;
    //newmessage.setNoteNumber(note);
    //newmessage.setChannel(channel);
    //newmessage.setVelocity(<#float newVelocity#>);
    
    mainOutput->sendMessageNow(newmessage);
    //cout << "note on " << note << " \n";
}

void MidiIO::sendNoteOff(int channel, int note, int vel)
{
    MidiMessage newmessage = MidiMessage::noteOff(channel, note, (uint8)0) ;
    mainOutput->sendMessageNow(newmessage);
}

void MidiIO::sendPolyAfter(int channel, int note, int value)
{
    MidiMessage newmessage = MidiMessage::aftertouchChange(channel, note, value) ;
    mainOutput->sendMessageNow(newmessage);
}

void MidiIO::sendChannelPressure(int channel, int value)
{
    MidiMessage newmessage = MidiMessage::channelPressureChange(channel, value);
    if (expOut){
		    expOutput->sendMessageNow(newmessage);

	}else{
		    mainOutput->sendMessageNow(newmessage);

	}
}

