/*
  ==============================================================================

    MapperGraph.h
    Created: 16 Aug 2016 6:20:31pm
    Author:  Studio One

  ==============================================================================
*/

#ifndef MAPPERGRAPH_H_INCLUDED
#define MAPPERGRAPH_H_INCLUDED

#include "JuceHeader.h"
#include <array>

//==============================================================================
/*
*/
class MapperGraph    : public Component,
                    private Button::Listener
{
public:
    MapperGraph();
    ~MapperGraph();

    void paint (Graphics&) override;
    void resized() override;
    void mouseEnter (const MouseEvent&) override;
    void mouseExit (const MouseEvent&) override;
    void mouseDrag (const MouseEvent&) override;
    //void mouseUp (const MouseEvent&) override;
    void mouseDown (const MouseEvent&) override;
    
    static const int numInputValues = 210;
    static const int numOutputValues = 128;
    //static const float ioFactor = numInputValues/numOutputValues;
    //static const float factor = getHeight()/getWidth();
    
    std::array<float, numInputValues+1> graphMap;

private:
    void buttonClicked (Button* but) override;
    
    
    //TooltipWindow graphTips;
    
    TextButton invertBut;
    TextButton flipBut;
    TextButton resetBut;
    
    
    int graphWidth;
    
    void invert();
    void flip();
    void reset();
    
    //Rectangle<int> drawcol(0,0,0,0);
    bool newGesture = true;
    float mouseXproportion;
    float mouseYproportion;
    float widthscale;
    float heightscale;
    
    int lastIndex = -1;
    
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (MapperGraph)
};


#endif  // MAPPERGRAPH_H_INCLUDED
