/*
  ==============================================================================

    MapperGraph.cpp
    Created: 16 Aug 2016 6:20:31pm
    Author:  Studio One

  ==============================================================================
*/

//#include "../modules/JuceHeader.h"
#include "MapperGraph.h"

#include<iostream>//enables c standard output
using namespace std;

//==============================================================================
MapperGraph::MapperGraph()
{
    newGesture = true;
    
    for (int i = 0; i < 210; ++i)
    {
        graphMap[i]=static_cast<int>(i*numOutputValues/numInputValues);
        //cout << "input " << (i) << " = output " << (graphMap[i]) << endl;
    }
    
    
    addAndMakeVisible(invertBut);
    invertBut.setButtonText("Invert");
    invertBut.addListener(this);
    invertBut.setTooltip("Invert graph");
    
    
    addAndMakeVisible(flipBut);
    flipBut.setButtonText("Flip");
    flipBut.addListener(this);
    flipBut.setTooltip("Mirror left to right");
    
    addAndMakeVisible(resetBut);
    resetBut.setButtonText("Reset");
    resetBut.addListener(this);
    resetBut.setTooltip("Reset Graph to X=Y");
    
    
    
    //graphTips.setMillisecondsBeforeTipAppears(650);
    cout << "MapperGraph constructed" << endl;

    
}

MapperGraph::~MapperGraph()
{
}

void MapperGraph::paint (Graphics& g)
{
    g.fillAll (Colours::white);   // clear the background
    
    g.setColour (Colours::lightgrey);
    Rectangle<int> butColumn(graphWidth,0,getWidth()-graphWidth,getHeight());
    g.fillRect(butColumn);

    g.setColour (Colours::grey);
    g.drawRect (getLocalBounds(), 1);   // draw an outline around the component
    g.setColour (Colours::lightgrey);
    g.drawLine (0, getHeight()/2, graphWidth, getHeight()/2 );
    g.drawLine (graphWidth/2, 0 , graphWidth/2, getHeight());

    auto graphcol = Colour(200,200,200);
    g.setColour (graphcol);//Draw actual array values
    for (int i = 0; i < numInputValues ; i++) {//iterate over array items not pixels!
        //width height
        float left = float(i*widthscale);
        float top = getHeight()-(float(graphMap[i])*heightscale);
        //float width = floor(widthscale);
        float width = 2;
        float height = float(graphMap[i])*heightscale;
        Rectangle<int> column(left,top,width,height);
        
        //Rectangle<int> column(i*widthscale,getHeight()-(graphMap[i]*heightscale),widthscale,graphMap[i]*heightscale);
        g.fillRect(column);
        //cout << "drew column " << (i) << endl;
        //cout << "fillrect " << (mouseX) << " " << (mouseY)<< endl;
    }
       // Rectangle<int> column(mouseX, mouseY, 1, getHeight()- mouseY);
       // g.fillRect(column);
        //cout << "fillrect " << (mouseX) << " " << (mouseY)<< endl;
    
    
    
}

void MapperGraph::resized()
{
    graphWidth = getWidth()*0.8;
    
    widthscale = float(graphWidth)/float(numInputValues);//dont recalc every time!!
    heightscale = float(getHeight())/float(numOutputValues);
    
    
    int columnWidth = (getWidth() - graphWidth);
    int buttonWidth = columnWidth*0.8;
    int margin = (columnWidth-buttonWidth)/2;
    int buttonHeight = getHeight()/10;
    //channelBox.setBounds (leftMargin,topMargin,buttonWidth,buttonHeight);
    
    invertBut.setBounds (graphWidth+margin,margin,buttonWidth,buttonHeight);
    flipBut.setBounds (graphWidth+margin,margin*2+buttonHeight,buttonWidth,buttonHeight);
    resetBut.setBounds (graphWidth+margin,margin*3+buttonHeight*2,buttonWidth,buttonHeight);
    
}


void MapperGraph::buttonClicked (Button* but)
{
    if (but == &invertBut)
    {
        invert();
    }
    else if (but == &flipBut)
    {
        flip();    }
    else if (but == &resetBut)
    {
        reset();
    }
    
}



void MapperGraph::reset ()
{
    //RESET MAPPING ARRAY
    for (int i = 0; i < numInputValues; ++i)
    {
        graphMap[i]=static_cast<int>(i*numOutputValues/numInputValues);
        //cout << "Linput " << (i) << " = output " << (graphMap[i]) << endl;
    }
    repaint();
}

void MapperGraph::flip ()
{
    
    auto oldMap = graphMap;
    for (int i = 0; i < numInputValues; ++i)
    {
        graphMap[i]=oldMap[numInputValues-i-1];
        //cout << "Linput " << (i) << " = output " << (graphMap[i]) << endl;
    }
    repaint();
}

void MapperGraph::invert ()
{
    
   // auto oldMap = graphMap;
    for (int i = 0; i < numInputValues; ++i)
    {
        graphMap[i] = numOutputValues-graphMap[i];
        //cout << "Linput " << (i) << " = output " << (graphMap[i]) << endl;
    }
    repaint();
}

void MapperGraph::mouseEnter (const MouseEvent& mouse)
{
    
}

void MapperGraph::mouseExit (const MouseEvent& mouse)
{
}


void MapperGraph::mouseDown (const MouseEvent& mouse)
{
    newGesture = true;
}

void MapperGraph::mouseDrag (const MouseEvent& mouse)
{
    int mouseX = jlimit(0 , graphWidth,  mouse.x);
    int mouseY = jlimit(0 , getHeight(),  mouse.y);
    if (mouse.x < graphWidth)
     {
        //cout << "mouseX = " << (mouse.x) << " mouseY = " << (mouse.y)<< endl;
        mouseXproportion =  float(mouseX)/float(graphWidth);
        mouseYproportion =  1-(float(mouseY)/float(getHeight()));
        //cout << "mouseXprop = " << (mouseXproportion) << " mouseYprop = " << (mouseYproportion)<< endl;
        int index = int(numInputValues * mouseXproportion);
        
        
        auto lastValue = graphMap[lastIndex];
        auto newValue = int((mouseYproportion*numOutputValues)-0.5);
        
        if (newGesture)
        {
            lastIndex = index;
            lastValue = newValue;
            newGesture = false;
        }
        
        
        auto distance = index - lastIndex;
        

        float v = lastValue;
        
        if (distance == 0)
        {
            graphMap[index] = newValue;
        }
        else
        {
            int direction = ((index - lastIndex) > 0) ? 1 : -1;
            float increment = float(direction) * (newValue - lastValue) / distance;
            auto i = lastIndex;
            //cout << "interpolation parameters lastindex =  " << lastIndex << " lastvalue = " << lastValue << " index = " << index << " newvalue = " << newValue <<endl;
            do
            {
                i += direction;
                v += increment;
                graphMap[i] = int(v);
                //cout << "interpolating - index =  " << i << " value = " << v << " increment = " << increment << endl;
            } while (i != index);
            
            lastValue = v;
        }//end else

        
        lastIndex = index;
        
        repaint();
     }
    
}
