/*
  ==============================================================================

    MantaData.h
    Created: 16 Apr 2016 10:58:01pm
    Author:  Studio One

  ==============================================================================
*/

#ifndef MANTADATA_H_INCLUDED
#define MANTADATA_H_INCLUDED

#include <array>
#include "JuceHeader.h"
#include "core/Manta.h"
#include "IsoEditor.h"
#include "ArbEditor.h"

#include "MapperGraph.h"
#include "LineGraph.h"

class MantaData
{
    
    
public:
    MantaData();
    ~MantaData();
    void transpose (int transposition);
    //void fillIsoNoteMap();//MOVED TO ISO
    void createDataTree();
    void loadDataTree();
    void loadXml();
    
    
    void save(ValueTree dataTree);
    File load();
    //void fillPressMap();
    int editMode = 1;
    
    int channel = 1;
    int expChan =1;
    
    int polyMono = 1;
    float thin = 1;
    int pollInterval = 1;
    
    bool fastVel = true;
    int slider0CC = 2;//breath //THESE MUST MATCH defaults in menu
    int slider1CC = 5;//porta
    
    int numMultiChannels = 8;
    int expressionMode = 1;
    int ccToUse = -1;
    
    bool hirescc = false;
    //bool expOut = false;
    
    int ledMessagePending = -1;
    
    int * redAndYellowLEDs;//0 = both, 1= red only , 2 = none
    
    bool arbNoteMode = false;
    
    IsoEditor theIsoEditor;
    ArbEditor theArbEditor;
    MapperGraph theMapperGraph;
    LineGraph theLineGraph;
    //LineGraph theVelGraph;
    
    Array<int, DummyCriticalSection, 50> notesDown;
    
    
    std::array<int, 50> * padToNoteMap; //points to either iso or arb according to mode
    //moved to iso editor std::array<int, 50> isoNoteMap; //array for map (one extra value each end uses 1-48)actually no uses 0-48
    
    

    
    std::array<float, 211> *pressMap;//pointer that switches between linegraph and mappergraph arrays
    
    bool exprOut;//manually connected to the MidiIO use this one as prime now
    
private:
    
    
    //int keyZeroNote = 30;//moved to iso
    
    
    
};


#endif  // MANTADATA_H_INCLUDED
