/*
  ==============================================================================

    MantaData.cpp
    Created: 16 Apr 2016 10:58:01pm
    Author:  Studio One

  ==============================================================================
*/

#include "MantaData.h"

#include<iostream>//enables c standard output
using namespace std;

MantaData::MantaData()
{
    padToNoteMap = &theIsoEditor.isoNoteMap;
    
    redAndYellowLEDs = &theIsoEditor.redAndYellowLEDs;
    
    theIsoEditor.theData = this;//actually only needs ledmessagepending?
    theArbEditor.theData = this;
    
    theIsoEditor.fillIsoNoteMap();
    
    notesDown.clear();
    
    cout << "thedata constructed " << endl;
}

MantaData::~MantaData()
{

}



void MantaData::transpose (int transposition)
{
    int newvalue;
    for (int i = 0; i < 50; ++i)
    {
        newvalue = (*padToNoteMap)[i]+transposition;
        if (newvalue > 127)
            newvalue -= 120;
        else if (newvalue < 0)
            newvalue += 120;
        (*padToNoteMap)[i] = newvalue;
        //cout << "transposed val = " << newvalue << endl;
    }
    if(arbNoteMode)
    theArbEditor.refresh();
    else
    theIsoEditor.refresh();

    cout << "transpose " << transposition << endl;
}



void MantaData::save(ValueTree dataTree)
{
    FileChooser myChooser ("Please select manta file or enter filename",
                           File::getSpecialLocation (File::userHomeDirectory),
                           "*.manta");
    
    if (myChooser.browseForFileToSave(true))
    {
        File testFile (myChooser.getResult());
        ScopedPointer<XmlElement> el = dataTree.createXml();
        //el->writeToFile(testFile, String::empty);
        el->writeToFile(testFile, "");
        
    }
}

File MantaData::load()
{
    FileChooser myChooser ("Please select a .manta file to load",
                           File::getSpecialLocation (File::userHomeDirectory),
                           "*.manta");
    if (myChooser.browseForFileToOpen())
    {
        File mantaFile (myChooser.getResult());
        return mantaFile;
        
    }
    return File();
}

void MantaData::loadDataTree()
{
    File loadedfile = load();
    if (loadedfile.getFullPathName() != "")
    {
        XmlDocument myDocument (loadedfile);
        ScopedPointer<XmlElement> xml (myDocument.getDocumentElement());
        
        if (xml != nullptr && xml->hasTagName ("dataTree"))
        {
            ValueTree dataTree;
            dataTree = ValueTree::fromXml(*xml);
            //GLOBALS
            fastVel=dataTree.getProperty("fastVel");
            channel=dataTree.getProperty("channel");
            pollInterval=dataTree.getProperty("pollInterval");
            editMode=dataTree.getProperty("editMode");
            
            //EXPRESSION
            thin=dataTree.getProperty("thin");
            slider0CC=dataTree.getProperty("slider0CC");
            slider1CC=dataTree.getProperty("slider1CC");
            numMultiChannels=dataTree.getProperty("numMultiChannels");
            expressionMode=dataTree.getProperty("expressionMode");
            
            ccToUse=dataTree.getProperty("ccToUse");
            hirescc=dataTree.getProperty("hirescc");
            exprOut=dataTree.getProperty("exprOut");
            
            
            
            //ISO TAB STUFF
            
            theIsoEditor.redAndYellowLEDs=dataTree.getProperty("ledMantaModeIso");
            
            theIsoEditor.upLeft=dataTree.getProperty("upLeft");
            //cout << " upLeft " << (theIsoEditor.upLeft) << endl;
            theIsoEditor.upRight=dataTree.getProperty("upRight");
            
            theIsoEditor.settingMode=dataTree.getProperty("settingModeIso");

            
            ValueTree isoNote;
            isoNote = dataTree.getChildWithName("isoNote");
            //cout << "isoNote as string = " << isoNote.toXmlString() << endl;
            //cout << "iterate through array = " << endl;
            
            for (int i = 0; i < 50; ++i)
            {
                theIsoEditor.isoNoteMap[i] = isoNote.getProperty("i"+String(i));
                //cout << ("isoNote "+String(i)+" - ") << (theIsoEditor.isoNoteMap[i]) << endl;
            }//end loop
            
            
            ValueTree padLedArrayIso;
            padLedArrayIso = dataTree.getChildWithName("padLedArrayIso");
            
            for (int i = 0; i < 50; ++i)
            {
                theIsoEditor.padLedArray[i] = padLedArrayIso.getProperty("i"+String(i));
                //cout << ("padLedArray "+String(i)+" - ") << (theIsoEditor.padLedArray[i]) << endl;
            }//end loop
            
            ValueTree pitchClassLedArrayIso;
            pitchClassLedArrayIso = dataTree.getChildWithName("pitchClassLedArrayIso");
            //cout << "pitchClassLedArrayIso as string = " << pitchClassLedArrayIso.toXmlString() << endl;
            for (int i = 0; i < 14; ++i)
            {
                theIsoEditor.pitchClassLedArray[i] = pitchClassLedArrayIso.getProperty("i"+String(i));
                //cout << ("pitchClassLedArrayIso "+String(i)+" - ") << (theIsoEditor.pitchClassLedArray[i]) << endl;
            }//end loop
            
            ValueTree midiNoteLedArrayIso;
            midiNoteLedArrayIso = dataTree.getChildWithName("midiNoteLedArrayIso");
            
            for (int i = 0; i < 128; ++i)
            {
                theIsoEditor.midiNoteLedArray[i] = midiNoteLedArrayIso.getProperty("i"+String(i));
                //cout << ("midiNoteLedArray "+String(i)+" - ") << (theLEDEditor.midiNoteLedArray[i]) << endl;
            }//end loop
            
            ///////////ARB / FREE TAB STUFF
            
            theArbEditor.redAndYellowLEDs=dataTree.getProperty("ledMantaModeArb");

            theArbEditor.settingMode=dataTree.getProperty("settingModeArb");

            
            ValueTree arbNote;
            arbNote = dataTree.getChildWithName("arbNote");
            //cout << "arbNoteTree as string = " << arbNoteTree.toXmlString() << endl;
            //cout << "iterate through array = " << endl;
            
            for (int i = 0; i < 50; ++i)
            {
                theArbEditor.arbNoteMap[i] = arbNote.getProperty("i"+String(i));
                //cout << ("arbNote "+String(i)+" - ") << (theArbEditor.arbNoteMap[i]) << endl;
            }//end loop
            
            
            ValueTree padLedArrayArb;
            padLedArrayArb = dataTree.getChildWithName("padLedArrayArb");
            
            for (int i = 0; i < 50; ++i)
            {
                theArbEditor.padLedArray[i] = padLedArrayArb.getProperty("i"+String(i));
            }//end loop
            
            ValueTree pitchClassLedArrayArb;
            pitchClassLedArrayArb = dataTree.getChildWithName("pitchClassLedArrayArb");
            
            for (int i = 0; i < 14; ++i)
            {
                theArbEditor.pitchClassLedArray[i] = pitchClassLedArrayArb.getProperty("i"+String(i));
            }//end loop
            
            ValueTree midiNoteLedArrayArb;
            midiNoteLedArrayArb = dataTree.getChildWithName("midiNoteLedArrayArb");
            
            for (int i = 0; i < 128; ++i)
            {
                theArbEditor.midiNoteLedArray[i] = midiNoteLedArrayArb.getProperty("i"+String(i));
            }//end loop
            
            //MAP GRAPH STUFF
            ValueTree mapGraph;
            mapGraph = dataTree.getChildWithName("mapGraph");
            
            for (int i = 0; i < theMapperGraph.numInputValues; ++i)
            {
                theMapperGraph.graphMap[i] = mapGraph.getProperty("i"+String(i));
                //cout << ("graphmap "+String(i)+" - ") << (theMapperGraph.graphMap[i]) << endl;
            }//end loop
            
            //LINE GRAPH STUFF
            ValueTree lineGraphNodes;
            lineGraphNodes = dataTree.getChildWithName("lineGraphNodes");
            theLineGraph.numNodes = lineGraphNodes.getProperty("numNodes");
            //cout << "loaded numnodes = " << theLineGraph.numNodes << endl;

            for (int i = 0; i < theLineGraph.maxNumNodes; ++i)
            {
                theLineGraph.nodeArray[i].x = lineGraphNodes.getProperty("x"+String(i));
                theLineGraph.nodeArray[i].y = lineGraphNodes.getProperty("y"+String(i));
                //cout << ("loaded linegraph node"+String(i)+" - x ") << theLineGraph.nodeArray[i].x << endl;
                //cout << ("loaded linegraph node"+String(i)+" - y ") << theLineGraph.nodeArray[i].y << endl;

            }//end loop
           
        }//end if xml is valid
    }//end if file exitsts
}

void MantaData::loadXml()//currently unused // may be easier way to do it
{
    //ScopedPointer<XmlElement> padNoteEl;
    
    File loadedfile = load();
    if (loadedfile.getFullPathName() != "")
    {
    
        XmlDocument myDocument (loadedfile);
        ScopedPointer<XmlElement> xml (myDocument.getDocumentElement());
        
        if (xml != nullptr && xml->hasTagName ("dataTree"))
        {
            theIsoEditor.upLeft = xml->getIntAttribute("upLeft");
            
            XmlElement * isoNoteEl = xml->getChildByName("isoNoteTree");
            
            //ScopedPointer<XmlElement> padNoteEl = xml->getChildByName("padNoteTree");
            
            
            for (int i = 0; i < 50; ++i)
            {
                theIsoEditor.isoNoteMap[i] = isoNoteEl->getAttributeValue(i).getIntValue();//get by index & convert resulting str to int
                //alt versionget by name
                //padToNoteMap[i] = padNoteEl->getIntAttribute("i"+String(i));
                cout << "isoNoteEl = " << isoNoteEl->getAttributeValue(i) << endl;
            }//end loop
            
        }//end if xml is valid
        
        
    }//end if file exitsts
    
}


void MantaData::createDataTree()
{
    ValueTree dataTree(String("dataTree"));
    //GLOBALS
    dataTree.setProperty(String("fastVel"), fastVel, nullptr);
    dataTree.setProperty(String("channel"), channel, nullptr);
    dataTree.setProperty(String("pollInterval"), pollInterval, nullptr);
    dataTree.setProperty(String("editMode"), editMode, nullptr);//tab selector //should be better named now?

    //EXPRESSION
    dataTree.setProperty(String("thin"), thin, nullptr);
    dataTree.setProperty(String("slider0CC"), slider0CC, nullptr);
    dataTree.setProperty(String("slider1CC"), slider1CC, nullptr);
    dataTree.setProperty(String("numMultiChannels"), numMultiChannels, nullptr);
    dataTree.setProperty(String("expressionMode"), expressionMode, nullptr);
    dataTree.setProperty(String("ccToUse"), ccToUse, nullptr);
    dataTree.setProperty(String("hirescc"), hirescc, nullptr);
    dataTree.setProperty(String("exprOut"), exprOut, nullptr);
    
    
    //ISO TAB STUFF
    dataTree.setProperty(String("ledMantaModeIso"), theIsoEditor.redAndYellowLEDs, nullptr);
    
    dataTree.setProperty(String("upLeft"), theIsoEditor.upLeft, nullptr);
    dataTree.setProperty(String("upRight"), theIsoEditor.upRight, nullptr);
    
    dataTree.setProperty(String("settingModeIso"), theIsoEditor.settingMode, nullptr);
    
    
    
    ValueTree isoNote(String("isoNote"));
    dataTree.addChild(isoNote, -1, nullptr);
    for (int i = 0; i < 50; ++i)
    {
         isoNote.setProperty("i"+String(i), theIsoEditor.isoNoteMap[i], nullptr);
    }
    
    ValueTree padLedArrayIso(String("padLedArrayIso"));
    dataTree.addChild(padLedArrayIso, -1, nullptr);
    for (int i = 0; i < 50; ++i)
    {
        padLedArrayIso.setProperty("i"+String(i), theIsoEditor.padLedArray[i], nullptr);
    }
    
    ValueTree pitchClassLedArrayIso(String("pitchClassLedArrayIso"));
    dataTree.addChild(pitchClassLedArrayIso, -1, nullptr);
    for (int i = 0; i < 14; ++i)
    {
        pitchClassLedArrayIso.setProperty("i"+String(i), theIsoEditor.pitchClassLedArray[i], nullptr);
    }
    
    ValueTree midiNoteLedArrayIso(String("midiNoteLedArrayIso"));
    dataTree.addChild(midiNoteLedArrayIso, -1, nullptr);
    for (int i = 0; i < 128; ++i)
    {
        midiNoteLedArrayIso.setProperty("i"+String(i), theIsoEditor.midiNoteLedArray[i], nullptr);
    }
    
    //ARB / FREE TAB STUFF
    
    dataTree.setProperty(String("ledMantaModeArb"), theArbEditor.redAndYellowLEDs, nullptr);

    
    dataTree.setProperty(String("settingModeArb"), theArbEditor.settingMode, nullptr);

    ValueTree arbNote(String("arbNote"));
    dataTree.addChild(arbNote, -1, nullptr);
    for (int i = 0; i < 50; ++i)
    {
        arbNote.setProperty("i"+String(i), theArbEditor.arbNoteMap[i], nullptr);
    }
    
    ValueTree padLedArrayArb(String("padLedArrayArb"));
    dataTree.addChild(padLedArrayArb, -1, nullptr);
    for (int i = 0; i < 50; ++i)
    {
        padLedArrayArb.setProperty("i"+String(i), theArbEditor.padLedArray[i], nullptr);
    }
    
    ValueTree pitchClassLedArrayArb(String("pitchClassLedArrayArb"));
    dataTree.addChild(pitchClassLedArrayArb, -1, nullptr);
    for (int i = 0; i < 14; ++i)
    {
        pitchClassLedArrayArb.setProperty("i"+String(i), theArbEditor.pitchClassLedArray[i], nullptr);
    }
    
    ValueTree midiNoteLedArrayArb(String("midiNoteLedArrayArb"));
    dataTree.addChild(midiNoteLedArrayArb, -1, nullptr);
    for (int i = 0; i < 128; ++i)
    {
        midiNoteLedArrayArb.setProperty("i"+String(i), theArbEditor.midiNoteLedArray[i], nullptr);
    }
    
    //MAP GRAPH STUFF
    ValueTree mapGraph(String("mapGraph"));
    dataTree.addChild(mapGraph, -1, nullptr);
    for (int i = 0; i < theMapperGraph.numInputValues; ++i)
    {
        mapGraph.setProperty("i"+String(i), (theMapperGraph.graphMap)[i], nullptr);
    };
    
    //LINE GRAPH STUFF
    ValueTree lineGraphNodes(String("lineGraphNodes"));
    lineGraphNodes.setProperty("numNodes", theLineGraph.numNodes, nullptr);

    dataTree.addChild(lineGraphNodes, -1, nullptr);
    for (int i = 0; i < theLineGraph.maxNumNodes; ++i)
    {//it's an array of points which have to be separated to ints
        lineGraphNodes.setProperty("x"+String(i), (theLineGraph.nodeArray)[i].x, nullptr);
        lineGraphNodes.setProperty("y"+String(i), (theLineGraph.nodeArray)[i].y, nullptr);
    };
    
    //shouldnt need to store graphmap from linegraph as it is created on the fly from the line graph
    
    save(dataTree);
}
