/*
 ==============================================================================
 
 This file was auto-generated!
 
 ==============================================================================
 */

#ifndef MAINCOMPONENT_H_INCLUDED
#define MAINCOMPONENT_H_INCLUDED

#include "JuceHeader.h"//relies on path set in projucer?
//#include <array>

#include "MyManta.h" 
#include "core/MantaExceptions.h"

//#include "MapperGraph.h"
//#include "LineGraph.h"
//#include "LEDEditor.h"

//==============================================================================
/*
 This component lives inside our window, and this is where you should put all
 your controls and content.
 */
class MainContentComponent   :  public Component,
                                private ComboBox::Listener,
                                private Button::Listener

{
public:
    //==============================================================================
    MainContentComponent();
    ~MainContentComponent();
    
    void paint (Graphics&) override;
    void resized() override;
    
    
    void mantaDisconnected();
    
private:
    void comboBoxChanged (ComboBox* box) override;
    void buttonClicked (Button* but) override;
    void showEditor();
    
    void loadGuiFromModel();
    TooltipWindow mantaTips;
    
    int serial = 0;//should be in mantadata
    
	
    
    TextButton connect;
    bool connectToManta();
    
    ComboBox channelBox;
    ComboBox pollIntervalBox;
    ComboBox thinBox;
    ComboBox slider0Box;
    ComboBox slider1Box;
    ComboBox multiChansBox;
    ComboBox expressionModeBox; //CC, polyafter or multichannel mode
    ComboBox ccExpBox;
    ComboBox hiresBox;
    ComboBox expOutBox;
    
    
    ComboBox setLedsOnMantabox; //manta settings mode// also in lededitor?
    ComboBox fileBox;
    
    ComboBox copyIsoArbBox;
    ComboBox copyArbIsoBox;
    
    ComboBox expChanBox;
    ComboBox polyModeBox;

    Label helpLabel;
    Label exprLabel;
    Label layoutLabel;
    //int editMode;
    
    Rectangle<int> editorBounds;
    Rectangle<int> globalSettingsBounds;
    Rectangle<int> expSettingsBounds;
    Rectangle<int> layoutSettingsBounds;
    
    TextButton fastVelBut;
    TextButton txUpSemiBut;
    TextButton txDownSemiBut;
    TextButton txUpOctBut;
    TextButton txDownOctBut;
    TextButton panic;
    TextButton lineGraphBut;
    TextButton freeGraphBut;
    TextButton isoSetBut;
    TextButton arbSetBut;
    
    TextButton isoToArbBut;
    
    MyManta theManta;
    
    

    //==============================================================================
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (MainContentComponent)
};


#endif  // MAINCOMPONENT_H_INCLUDED
