/*
  ==============================================================================

    This file was auto-generated!

  ==============================================================================
*/

#include "MainComponent.h"
//#include "MyManta.h"
//#import "core/MantaExceptions.h"

#include<iostream>//enables c standard output
using namespace std;


//==============================================================================
MainContentComponent::MainContentComponent()
{
    mantaTips.setMillisecondsBeforeTipAppears(650);
    
    if (auto* lf = dynamic_cast<LookAndFeel_V4*>(&getLookAndFeel()))
        lf->setColourScheme (LookAndFeel_V4::getLightColourScheme());
        //create own colour scheme?? integrate all colours into a scheme
    
    //--------------------------------
    
    
    addAndMakeVisible(channelBox);
    channelBox.setTooltip("Sets base midi channel");
    
    for (int i = 1; i < 17; ++i)
    {
        channelBox.addItem("ch "+String(i), i);
        
    }
    channelBox.addListener(this);
    channelBox.setSelectedId(1, dontSendNotification);
    
    addAndMakeVisible(expChanBox);
    expChanBox.setTooltip("Sets expression midi channel");
    
    for (int i = 1; i < 17; ++i)
    {
        expChanBox.addItem("ch "+String(i), i);
        
    }
    expChanBox.addListener(this);
    expChanBox.setSelectedId(1, dontSendNotification);

    //change to 0.25, 0.5 1,2,4,8
    addAndMakeVisible(thinBox);
    thinBox.setTooltip("Amount change for a new message to be sent. based on 0-127 msb");
	thinBox.addItem ("0", 1);
    thinBox.addItem ("0.2", 2);
    thinBox.addItem ("0.5", 3);
    thinBox.addItem ("1", 4);
    thinBox.addItem ("2", 5);
    thinBox.addItem ("4", 6);
    thinBox.addItem ("8", 7);
    thinBox.addListener(this);
    thinBox.setSelectedId(4, dontSendNotification);
    
    addAndMakeVisible(pollIntervalBox);
    pollIntervalBox.setTooltip("How often to check the manta for new events. Shorter times = more cpu.");
    for (int i = 1; i < 7; ++i)
    {
        pollIntervalBox.addItem(String(i)+ "ms", i);
        
    }
    pollIntervalBox.addListener(this);
    pollIntervalBox.setSelectedId(1, dontSendNotification);
    
    
    addAndMakeVisible(slider0Box);
    slider0Box.setTooltip("Which CC number to attribute to top slider");
    slider0Box.addItem ("Sli1 CC1 Modwh", 1);
    slider0Box.addItem ("Sli1 CC2 Breath", 2);
    slider0Box.addItem ("Sli1 CC3 Undef", 3);
    slider0Box.addItem ("Sli1 CC4 Foot", 4);
    slider0Box.addItem ("Sli1 CC7 Vol", 5);
    slider0Box.addItem ("Sli1 CC10 Pan", 6);
    slider0Box.addItem ("Sli1 CC11 Exp", 7);
    slider0Box.addItem ("Sli1 CC5 Porta", 8);
    slider0Box.addListener(this);
    slider0Box.setSelectedId(2, dontSendNotification);
    
    
    addAndMakeVisible(slider1Box);
    slider1Box.setTooltip("Which CC number to attribute to lower slider");
    slider1Box.addItem ("Sli2 CC1 Mod", 1);
    slider1Box.addItem ("Sli2 CC2 Breath", 2);
    slider1Box.addItem ("Sli2 CC3 Undef", 3);
    slider1Box.addItem ("Sli2 CC4 Foot", 4);
    slider1Box.addItem ("Sli2 CC7 Vol", 5);
    slider1Box.addItem ("Sli2 CC10 Pan", 6);
    slider1Box.addItem ("Sli2 CC11 Exp", 7);
    slider1Box.addItem ("Sli1 CC5 Porta", 8);
    slider1Box.addListener(this);
    slider1Box.setSelectedId(8, dontSendNotification);
    
    
    addAndMakeVisible(multiChansBox);
    multiChansBox.setTooltip("How many channels to use in multi channel expression mode");
    for (int i = 2; i <= 16; i++)
    {
        multiChansBox.addItem(String(i) + " channel multi", i);
        
    }
    multiChansBox.addListener(this);
    multiChansBox.setSelectedId(8, dontSendNotification);
    multiChansBox.setEnabled(false);
    
    
    addAndMakeVisible(expressionModeBox);
    expressionModeBox.setTooltip("send pad coverage data as");
    expressionModeBox.addItem ("Poly Aftertouch", 1);
    expressionModeBox.addItem ("CC one channel", 2);
    expressionModeBox.addItem ("Multi channel CC", 3);
    expressionModeBox.addItem ("Off", 4);
    expressionModeBox.addListener(this);
    expressionModeBox.setSelectedId(1, dontSendNotification);
    
    addAndMakeVisible(polyModeBox);
    polyModeBox.setTooltip("poly/monophonic mode");
    polyModeBox.addItem ("Polyphonic", 1);
    polyModeBox.addItem ("Mono Legato", 2);
    polyModeBox.addItem ("Mono Retrig", 3);
    polyModeBox.addListener(this);
    polyModeBox.setSelectedId(1, dontSendNotification);
    
    addAndMakeVisible(ccExpBox);
    ccExpBox.setTooltip("Which CC number to send pad coverage data as");
    ccExpBox.addItem ("Pad CC1 Mod", 1);
    ccExpBox.addItem ("Pad CC2 Breath", 2);
    ccExpBox.addItem ("Pad CC3 Undef", 3);
    ccExpBox.addItem ("Pad CC4 Foot", 4);
    ccExpBox.addItem ("Pad CC7 Vol", 5);
    ccExpBox.addItem ("Pad CC10 Pan", 6);
    ccExpBox.addItem ("Pad CC11 Exp", 7);
    ccExpBox.addItem ("Pad Chan Press", 8);
    ccExpBox.addListener(this);
    ccExpBox.setSelectedId(8, dontSendNotification);
    ccExpBox.setEnabled(false);
    
    addAndMakeVisible(hiresBox);
    hiresBox.setTooltip("hi res controllers?");
    hiresBox.addItem ("7bit CC", 1);
    hiresBox.addItem ("14bit CC", 2);
    hiresBox.addListener(this);
    hiresBox.setSelectedId(1, dontSendNotification);
    hiresBox.setEnabled(false);
    
    addAndMakeVisible(expOutBox);
    expOutBox.setTooltip("Exp Out sends expression messages to alternate midi output for separate processing.  Doesn't apply to PolyAfter");
    expOutBox.addItem ("Normal", 1);
    expOutBox.addItem ("Exp Out", 2);
    expOutBox.addListener(this);
    expOutBox.setSelectedId(1, dontSendNotification);
    expOutBox.setEnabled(false);
    
    addAndMakeVisible(fileBox);
    fileBox.setTooltip("save and load settings");
    fileBox.addItem ("file", 1);
    fileBox.addItem ("save", 2);
    fileBox.addItem ("load", 3);
    fileBox.addListener(this);
    fileBox.setSelectedId(1, dontSendNotification);
    
    
    addAndMakeVisible(lineGraphBut);
    lineGraphBut.setButtonText("Exp Graph");
    lineGraphBut.addListener(this);
    lineGraphBut.setTooltip("edit expression mapping on a line graph");
    lineGraphBut.setRadioGroupId(1, dontSendNotification);
    lineGraphBut.setConnectedEdges(8);
    lineGraphBut.setClickingTogglesState(true);
    lineGraphBut.setColour(TextButton::buttonOnColourId, Colours::lightblue);
    //lineGraphBut.setColour(TextButton::buttonColourId, Colours::lightgrey);
    //lineGraphBut.setColour(TextButton::textColourOnId, Colours::black);
    //lineGraphBut.setColour(TextButton::textColourOffId, Colours::black);
    lineGraphBut.setToggleState(true, dontSendNotification);
    
    addAndMakeVisible(freeGraphBut);
    freeGraphBut.setButtonText("Exp Graph 2");
    freeGraphBut.addListener(this);
    freeGraphBut.setTooltip("edit expression mapping on a drag mapper");
    freeGraphBut.setRadioGroupId(1, dontSendNotification);
    freeGraphBut.setConnectedEdges(8);
    freeGraphBut.setClickingTogglesState(true);
    freeGraphBut.setColour(TextButton::buttonOnColourId, Colours::lightblue);
    
    
    addAndMakeVisible(isoSetBut);
    isoSetBut.setButtonText("Isomorphic Layout");
    isoSetBut.addListener(this);
    isoSetBut.setTooltip("activate and set the iso note layout and attached led settings");
    isoSetBut.setRadioGroupId(1, dontSendNotification);
    isoSetBut.setConnectedEdges(8);
    isoSetBut.setClickingTogglesState(true);
    isoSetBut.setColour(TextButton::buttonOnColourId, Colours::lightblue);

    
    addAndMakeVisible(arbSetBut);
    arbSetBut.setButtonText("Free Layout");
    arbSetBut.addListener(this);
    arbSetBut.setTooltip("activate and set the free note layout and attached led settings");
    arbSetBut.setRadioGroupId(1, dontSendNotification);
    arbSetBut.setConnectedEdges(8);
    arbSetBut.setClickingTogglesState(true);
    arbSetBut.setColour(TextButton::buttonOnColourId, Colours::lightblue);
    //arbSetBut.setEnabled(false);//starts in iso layout so disbles setting arb

    
    addAndMakeVisible(fastVelBut);
    fastVelBut.setButtonText("Fast Vel Mode");
    fastVelBut.addListener(this);
    fastVelBut.setTooltip("Fast Vel mode uses first pad touch value as velocity. Manta Vel mode calculates a velocity based on first 2 pad values, so adds 6ms latency.");
    fastVelBut.setClickingTogglesState(true);
    fastVelBut.setColour(TextButton::buttonOnColourId, Colours::lightblue);
    fastVelBut.setColour(TextButton::buttonColourId, Colours::lightgoldenrodyellow);
    fastVelBut.setColour(TextButton::textColourOnId, Colours::black);
    fastVelBut.setColour(TextButton::textColourOffId, Colours::black);
    
    
    
    
    
    addAndMakeVisible(txDownSemiBut);
    txDownSemiBut.setButtonText("-1");
    txDownSemiBut.addListener(this);
    txDownSemiBut.setTooltip("transpose down a semitone");
    
    addAndMakeVisible(txUpSemiBut);
    txUpSemiBut.setButtonText("+1");
    txUpSemiBut.addListener(this);
    txUpSemiBut.setTooltip("transpose up a semitone");
    
    addAndMakeVisible(txDownOctBut);
    txDownOctBut.setButtonText("-12");
    txDownOctBut.addListener(this);
    txDownOctBut.setTooltip("transpose down an octave");
    
    addAndMakeVisible(txUpOctBut);
    txUpOctBut.setButtonText("+12");
    txUpOctBut.addListener(this);
    txUpOctBut.setTooltip("transpose up an octave");
    
    addAndMakeVisible(panic);
    panic.setButtonText("Panic");
    panic.addListener(this);
    panic.setTooltip("send allnotesoff");
    
    addAndMakeVisible(connect);
    connect.setButtonText("Connect");
    connect.addListener(this);
    connect.setTooltip("connect to manta");
    //connect.setClickingTogglesState(true);
    connect.setToggleState(false, dontSendNotification);
    connect.setColour(TextButton::buttonOnColourId, Colours::lightgreen);
    connect.setColour(TextButton::textColourOnId, Colours::black);
    connect.setColour(TextButton::textColourOffId, Colours::black);
    //connect.setColour(TextButton::buttonColourId, Colours::lightgoldenrodyellow);
    
    addAndMakeVisible(isoToArbBut);
    isoToArbBut.setButtonText("Copy notes Iso->Free");
    isoToArbBut.addListener(this);
    isoToArbBut.setTooltip("copy the current iso note layout to the arbitrary note layout");
    
    addAndMakeVisible(copyIsoArbBox);
    copyIsoArbBox.setTooltip("copy LED settings from iso layout to free layout");
    copyIsoArbBox.addItem ("Copy LEDs iso->free", 1);
    copyIsoArbBox.addItem ("by Pitch Class", 2);
    copyIsoArbBox.addItem ("by Pad", 3);
    copyIsoArbBox.addItem ("by Midi Note number", 4);
    copyIsoArbBox.addItem ("All 3 setting types", 5);
    copyIsoArbBox.addListener(this);
    copyIsoArbBox.setSelectedId(1, dontSendNotification);
    
    addAndMakeVisible(copyArbIsoBox);
    copyArbIsoBox.setTooltip("copy LED settings from free layout to iso layout");
    copyArbIsoBox.addItem ("Copy LEDs free->iso", 1);
    copyArbIsoBox.addItem ("by Pitch Class", 2);
    copyArbIsoBox.addItem ("by Pad", 3);
    copyArbIsoBox.addItem ("by Midi Note number", 4);
    copyArbIsoBox.addItem ("All 3 setting types", 5);
    copyArbIsoBox.addListener(this);
    copyArbIsoBox.setSelectedId(1, dontSendNotification);
    

    addAndMakeVisible(helpLabel);
    addAndMakeVisible(exprLabel);
    addAndMakeVisible(layoutLabel);
    exprLabel.setText("Expression Settings", dontSendNotification);
    layoutLabel.setText("Layout and LED Settings", dontSendNotification);
    
    cout << "main component constructed" << endl;
    
    //MyManta theManta;
    
    theManta.mainComponent = this;
    

    //connectToManta();//START THE MANTA!!
    connect.setToggleState(connectToManta(), dontSendNotification);//this way it sets the button according to success at connecting

    
    
    //-------------------------------
    setSize (600, 600);
}

MainContentComponent::~MainContentComponent()
{
    theManta.Manta::ClearPadAndButtonLEDs();
    theManta.signalThreadShouldExit();
    theManta.notify();
    theManta.stopThread(200);
    
}

void MainContentComponent::paint (Graphics& g)
{
    g.fillAll (Colours::palegoldenrod);
    g.setColour (Colours::lightgrey);
    g.fillRect(globalSettingsBounds);
    
    g.setColour (Colours::lightblue);
    g.fillRect(layoutSettingsBounds);
    
    g.setColour (Colours::lightsteelblue);
    g.fillRect(expSettingsBounds);
    //cout << "main component repainted" << endl;
    
}

void MainContentComponent::resized()
{
    Rectangle<int> area (getLocalBounds());
    //midiInputList.setBounds (area.removeFromTop (36).removeFromRight (getWidth() - 150).reduced (8));
    
    float rowHeight = getHeight()/20;
    float columnWidth = getWidth()/8.4
    ;
    float margin = getWidth()/40;
    
    float narrowMargin = margin/2;
    
    float buttonHeight = rowHeight-narrowMargin;
    float buttonWidth = columnWidth-narrowMargin;
    float wideButWidth = columnWidth*2-narrowMargin;
    float veryWideButWidth = columnWidth*3-narrowMargin;
    
    float wideBoxWidth = buttonWidth*2.6;
    
    float extraMargin = margin+narrowMargin;
    
    float expWidthProp=0.55;

    //row 1 (global controls)
    channelBox.setBounds (margin,margin,buttonWidth,buttonHeight);
    fileBox.setBounds (margin+columnWidth,margin,buttonWidth,buttonHeight);
    pollIntervalBox.setBounds (margin+columnWidth*2,margin,buttonWidth,buttonHeight);
    fastVelBut.setBounds (margin+columnWidth*3,margin,wideButWidth,buttonHeight);
    panic.setBounds (margin+columnWidth*5,margin,buttonWidth,buttonHeight);
    connect.setBounds (margin+columnWidth*6,margin,wideButWidth,buttonHeight);
    
    polyModeBox.setBounds (margin,margin+rowHeight,wideButWidth,buttonHeight);
    
    
    
    //(expression controls)
    
    exprLabel.setBounds(margin,extraMargin+rowHeight*2,columnWidth*3,buttonHeight);
    
    slider0Box.setBounds (margin,extraMargin+rowHeight*3,wideBoxWidth,buttonHeight);
    slider1Box.setBounds (margin,extraMargin+rowHeight*4,wideBoxWidth,buttonHeight);
    
    expressionModeBox.setBounds (margin,extraMargin+rowHeight*5,wideBoxWidth,buttonHeight);
    
    expChanBox.setBounds (margin*1.5+wideBoxWidth,extraMargin+rowHeight*5,buttonWidth*1.5,buttonHeight);
    ccExpBox.setBounds (margin,extraMargin+rowHeight*6,wideBoxWidth,buttonHeight);
    
    multiChansBox.setBounds (margin,extraMargin+rowHeight*7,wideBoxWidth,buttonHeight);
    
    thinBox.setBounds (margin,extraMargin+rowHeight*8,wideBoxWidth,buttonHeight);
    
    hiresBox.setBounds (margin*1.5+wideBoxWidth,extraMargin+rowHeight*6,buttonWidth*1.5,buttonHeight);
    expOutBox.setBounds (margin*1.5+wideBoxWidth,extraMargin+rowHeight*8,buttonWidth*1.5,buttonHeight);
  
    //(note and led layout controls)
    
    float layoutAreaX = getWidth()*expWidthProp+margin;
    
    layoutLabel.setBounds (layoutAreaX,extraMargin+rowHeight*2,columnWidth,buttonHeight);

    txDownSemiBut.setBounds (layoutAreaX,extraMargin+rowHeight*3,buttonWidth,buttonHeight);
    txUpSemiBut.setBounds (layoutAreaX+columnWidth,extraMargin+rowHeight*3,buttonWidth,buttonHeight);
    txDownOctBut.setBounds (layoutAreaX,extraMargin+rowHeight*4,buttonWidth,buttonHeight);
    txUpOctBut.setBounds (layoutAreaX+columnWidth,extraMargin+rowHeight*4,buttonWidth,buttonHeight);
    
    isoToArbBut.setBounds (layoutAreaX,extraMargin+rowHeight*5,veryWideButWidth,buttonHeight);
    
    copyArbIsoBox.setBounds (layoutAreaX,extraMargin+rowHeight*6,veryWideButWidth,buttonHeight);
    copyIsoArbBox.setBounds (layoutAreaX,extraMargin+rowHeight*7,veryWideButWidth,buttonHeight);
    
    
    //editModeBox.setBounds (margin,margin+rowHeight*8,buttonWidth*3,buttonHeight);
    
    
    
    Rectangle<int> elementBounds(narrowMargin, getHeight()*0.54, getWidth()-narrowMargin*2, getHeight()*0.4);
    editorBounds = elementBounds;//why can't i set it directly?
    
    Rectangle<int> elementBounds2(narrowMargin, narrowMargin, getWidth()-narrowMargin*2, rowHeight*2+narrowMargin);
    globalSettingsBounds = elementBounds2;
    
    Rectangle<int> elementBounds3(narrowMargin, margin+rowHeight*2, (getWidth()-narrowMargin*3)*expWidthProp, narrowMargin+rowHeight*7);
    expSettingsBounds = elementBounds3;
    
    Rectangle<int> elementBounds4(getWidth()*expWidthProp + narrowMargin/2, margin+rowHeight*2, (getWidth()-narrowMargin*3)*(1-expWidthProp), narrowMargin+rowHeight*7);
    layoutSettingsBounds = elementBounds4;

    
    lineGraphBut.setBounds(elementBounds.getX(), elementBounds.getY()-buttonHeight,buttonWidth*2,buttonHeight);
    freeGraphBut.setBounds(elementBounds.getX()+buttonWidth*2, elementBounds.getY()-buttonHeight,buttonWidth*2,buttonHeight);
    isoSetBut.setBounds(elementBounds.getX()+buttonWidth*4, elementBounds.getY()-buttonHeight,buttonWidth*2,buttonHeight);
    arbSetBut.setBounds(elementBounds.getX()+buttonWidth*6, elementBounds.getY()-buttonHeight,buttonWidth*2,buttonHeight);
    
    helpLabel.setBounds (margin, getHeight()*0.95, getWidth()-margin*2, getHeight()*0.05);
    helpLabel.setJustificationType(Justification::centred);
    helpLabel.setFont(getHeight()*0.03);
    
    showEditor();
    //theManta.theData.theLEDEditor.refresh();
    
}

void MainContentComponent::showEditor()
{
    
    removeChildComponent(&theManta.theData.theLineGraph);
    removeChildComponent(&theManta.theData.theMapperGraph);
    removeChildComponent(&theManta.theData.theIsoEditor);
    removeChildComponent(&theManta.theData.theArbEditor);
    
    
    switch(theManta.theData.editMode)
    {
        case 1:
            theManta.theData.theLineGraph.setBounds(editorBounds);
            addAndMakeVisible(&theManta.theData.theLineGraph,-1);
            theManta.theData.theLineGraph.recalcGraphMap();
            theManta.theData.pressMap = &theManta.theData.theLineGraph.graphMap;//switch the pointer in thedata to point at linegraph array
            helpLabel.setText("double click to add or remove points", dontSendNotification);
            break;
        case 2:
            theManta.theData.theMapperGraph.setBounds(editorBounds);
            addAndMakeVisible(&theManta.theData.theMapperGraph,-1);
            theManta.theData.pressMap = &theManta.theData.theMapperGraph.graphMap;//switch the pointer in thedata to point at mappergraph array
            helpLabel.setText("drag to draw", dontSendNotification);
            
            break;
        case 3:
            theManta.theData.arbNoteMode = false;
            theManta.theData.padToNoteMap = &theManta.theData.theIsoEditor.isoNoteMap;
            theManta.theData.redAndYellowLEDs = &theManta.theData.theIsoEditor.redAndYellowLEDs;
            
            
            theManta.theData.theIsoEditor.setBounds(editorBounds);
            addAndMakeVisible(&theManta.theData.theIsoEditor,-1);

            theManta.theData.theIsoEditor.refresh();
            
            helpLabel.setText("click to set LEDs. Use upleft & upright to specify isomorphic layout", dontSendNotification);
            
            break;
        case 4:
            theManta.theData.arbNoteMode = true;

            theManta.theData.padToNoteMap = &theManta.theData.theArbEditor.arbNoteMap;
            
            theManta.theData.redAndYellowLEDs = &theManta.theData.theArbEditor.redAndYellowLEDs;

            theManta.theData.theArbEditor.setBounds(editorBounds);
            addAndMakeVisible(&theManta.theData.theArbEditor,-1);

            theManta.theData.theArbEditor.refresh();

            helpLabel.setText("left click for leds, right click for semis, middle or shift click for 8ves", dontSendNotification);
            
            break;
        default:
            throw std::invalid_argument("edit mode error");
    }

}



void MainContentComponent::comboBoxChanged (ComboBox* box)
{
    int menuidx;
    
    if (box == &channelBox)
    {
        menuidx = (channelBox.getSelectedItemIndex());
        theManta.theData.channel = menuidx+1;
        cout << "channel= " << theManta.theData.channel << endl;
    }
    else if (box == &expChanBox)
    {
        menuidx = (expChanBox.getSelectedItemIndex());
        theManta.theData.expChan = menuidx+1;
        cout << "expChan= " << theManta.theData.expChan << endl;
    }
    else if (box == &polyModeBox)
    {
        menuidx = 1+(polyModeBox.getSelectedItemIndex());
         switch(menuidx)
        {
            case 1:
                theManta.theData.polyMono = 1;//polyphonic
                break;
            case 2:
                theManta.theData.polyMono =2;//legato
                break;
            case 3:
                theManta.theData.polyMono = 3;//retrigger
                break;
            default:
                throw std::invalid_argument("polyMono setting error");
        }
        theManta.panic();
        theManta.theData.notesDown.clear();
        cout << "polyMono= " << theManta.theData.polyMono << endl;
    }
    else if (box == &thinBox)
    {
        menuidx = 1+(thinBox.getSelectedItemIndex());
         switch(menuidx)
        {
            case 1:
                theManta.theData.thin = 0;
                break;
            case 2:
                theManta.theData.thin = 0.2;
                break;
            case 3:
                theManta.theData.thin = 0.5;
                break;
            case 4:
                theManta.theData.thin = 1;
                break;
            case 5:
                theManta.theData.thin = 2;
                break;
            case 6:
                theManta.theData.thin = 4;
                break;
            case 7:
                theManta.theData.thin = 8;
                break;
            default:
                throw std::invalid_argument("thin setting error");
        }
        theManta.panic();
        cout << "thin= " << theManta.theData.thin << endl;
    }
    else if (box == &pollIntervalBox)
    {
        menuidx = (pollIntervalBox.getSelectedItemIndex());
        theManta.theData.pollInterval = menuidx+1;
        cout << "pollInterval= " << theManta.theData.pollInterval << endl;
    }
    else if (box == &slider0Box)
    {
        menuidx = 1+(slider0Box.getSelectedItemIndex());
        switch(menuidx)
        {
            case 1:
                theManta.theData.slider0CC = 1;
                break;
            case 2:
                theManta.theData.slider0CC = 2;
                break;
            case 3:
                theManta.theData.slider0CC = 3;
                break;
            case 4:
                theManta.theData.slider0CC = 4;
                break;
            case 5:
                theManta.theData.slider0CC = 7;
                break;
            case 6:
                theManta.theData.slider0CC = 10;
                break;
            case 7:
                theManta.theData.slider0CC = 11;
                break;
			case 8:
                theManta.theData.slider0CC = 5;//portamento
                break;
            default:
                throw std::invalid_argument("CC setting error");
        }
    }
    else if (box == &slider1Box)
    {
        menuidx = 1+(slider1Box.getSelectedItemIndex());
        switch(menuidx)
        {
            case 1:
                theManta.theData.slider1CC = 1;
                break;
            case 2:
                theManta.theData.slider1CC = 2;
                break;
            case 3:
                theManta.theData.slider1CC = 3;
                break;
            case 4:
                theManta.theData.slider1CC = 4;
                break;
            case 5:
                theManta.theData.slider1CC = 7;
                break;
            case 6:
                theManta.theData.slider1CC = 10;
                break;
            case 7:
                theManta.theData.slider1CC = 11;
                break;
			case 8:
                theManta.theData.slider1CC = 5;//portamento
                break;
            default:
                throw std::invalid_argument("CC setting error");
        }
       
    }
    else if (box == &ccExpBox)
    {
        menuidx = 1+(ccExpBox.getSelectedItemIndex());
        switch(menuidx)
        {
            case 1:
                theManta.theData.ccToUse = 1;
                hiresBox.setEnabled(true);
                break;
            case 2:
                theManta.theData.ccToUse = 2;
                hiresBox.setEnabled(true);
                break;
            case 3:
                theManta.theData.ccToUse = 3;
                hiresBox.setEnabled(true);
                break;
            case 4:
                theManta.theData.ccToUse = 4;
                hiresBox.setEnabled(true);
                break;
            case 5:
                theManta.theData.ccToUse = 7;
                hiresBox.setEnabled(true);
                break;
            case 6:
                theManta.theData.ccToUse = 10;
                hiresBox.setEnabled(true);
                break;
            case 7:
                theManta.theData.ccToUse = 11;
                hiresBox.setEnabled(true);
                break;
            case 8:
                theManta.theData.ccToUse = -1;
                hiresBox.setEnabled(false);
                break;
            default:
                throw std::invalid_argument("CC setting error");
        }
        //cout << "CC is changed to " << theManta.theData.ccToUse << endl;
       
    }
    else if (box == &hiresBox)
    {
        menuidx = 1+(hiresBox.getSelectedItemIndex());
        switch(menuidx)
        {
            case 1:
                theManta.theData.hirescc = false;
                break;
            case 2:
                theManta.theData.hirescc = true;
                break;
            default:
                throw std::invalid_argument("hires setting error");
        }
        cout << "hires set to " << theManta.theData.hirescc << endl;
        theManta.panic();
       
    }
        else if (box == &expOutBox)
    {
        menuidx = 1+(expOutBox.getSelectedItemIndex());
        
        switch(menuidx)
        {
            case 1:
                theManta.theData.exprOut = false;
                //theManta.theData.exprOut = &theManta.theMidiIO.expOut;
                //this should only need doing once??
                break;
            case 2:
                theManta.theData.exprOut = true;
                break;
            default:
                throw std::invalid_argument("expOut setting error");
        }
        theManta.theMidiIO.expOut=theManta.theData.exprOut;
        cout << "exprOut=" << theManta.theData.exprOut << "expOut=" << theManta.theMidiIO.expOut << endl;
        theManta.panic();
       
    }
    else if (box == &expressionModeBox)
    {
        theManta.theData.expressionMode =  1+(expressionModeBox.getSelectedItemIndex());

        switch(theManta.theData.expressionMode)
        {
            case 1:
                //polyafter
                multiChansBox.setEnabled(false);
                ccExpBox.setEnabled(false);
                expOutBox.setEnabled(false);
                hiresBox.setEnabled(false);
                expOutBox.setEnabled(false);//polyafter requires that expression and notes are on same channel and output
                expChanBox.setEnabled(false);
                break;
            case 2:
                //CC
                multiChansBox.setEnabled(false);
                ccExpBox.setEnabled(true);
                expOutBox.setEnabled(true);
                hiresBox.setEnabled(true);//except shouldnt be enabled for chan pressure...
                expOutBox.setEnabled(true);
                expChanBox.setEnabled(true);
                break;
            case 3:
                //multi mode
                multiChansBox.setEnabled(true);
                ccExpBox.setEnabled(true);
                expOutBox.setEnabled(true);
                hiresBox.setEnabled(true);
                expOutBox.setEnabled(false);//doesn't make sense to send CC on different output in MPE mode
                expChanBox.setEnabled(false);//CC channel has to match note channel in MPE mode
                break;
            case 4:
                //off
                multiChansBox.setEnabled(false);
                ccExpBox.setEnabled(false);
                expOutBox.setEnabled(false);
                hiresBox.setEnabled(false);
                expOutBox.setEnabled(false);
                expChanBox.setEnabled(false);

                break;
            default:
                throw std::invalid_argument("edit mode error");
        }
        
        cout << "expressionMode = " << theManta.theData.expressionMode << endl;

        
    }else if (box == &multiChansBox)
    {
        menuidx = (multiChansBox.getSelectedItemIndex());
        theManta.theData.numMultiChannels = menuidx +2;//(index starts at 0 and first item is 2)
        cout << "nummultichans = " << theManta.theData.numMultiChannels << endl;
    }
    else if (box == &fileBox)
    {
        menuidx = (fileBox.getSelectedItemIndex());
        switch(menuidx+1)
        {
            case 1:
                    //nothing
                break;
            case 2:
                cout << "save" << menuidx << endl;
                theManta.theData.createDataTree();
                break;
            case 3:
                cout << "load" << menuidx << endl;
                theManta.theData.loadDataTree();
                loadGuiFromModel();
                break;
            default:
                throw std::invalid_argument("edit mode error");
        }
        fileBox.setSelectedId(1, dontSendNotification);

    }else if (box == &copyArbIsoBox)
    {
        menuidx = (copyArbIsoBox.getSelectedItemIndex());
        switch(menuidx+1)
        {
            case 1:
                //nothing
                break;
            case 2:
                cout << "copy pitch class LEDs arb->iso" << menuidx << endl;
                theManta.theData.theIsoEditor.pitchClassLedArray = theManta.theData.theArbEditor.pitchClassLedArray;
                break;
            case 3:
                cout << "copy pad LEDs arb->iso" << menuidx << endl;
                theManta.theData.theIsoEditor.padLedArray = theManta.theData.theArbEditor.padLedArray;
                break;
            case 4:
                cout << "copy midi note LEDs arb->iso" << menuidx << endl;
                theManta.theData.theIsoEditor.midiNoteLedArray = theManta.theData.theArbEditor.midiNoteLedArray;
                break;
            case 5:
                cout << "copy all LED settings arb->iso" << menuidx << endl;
                theManta.theData.theIsoEditor.pitchClassLedArray = theManta.theData.theArbEditor.pitchClassLedArray;
                theManta.theData.theIsoEditor.padLedArray = theManta.theData.theArbEditor.padLedArray;
                theManta.theData.theIsoEditor.midiNoteLedArray = theManta.theData.theArbEditor.midiNoteLedArray;
                break;
            default:
                throw std::invalid_argument("edit mode error");
        }
        copyArbIsoBox.setSelectedId(1, dontSendNotification);
        theManta.theData.theIsoEditor.refresh();
    }
    else if (box == &copyIsoArbBox)
    {
        menuidx = (copyIsoArbBox.getSelectedItemIndex());
        switch(menuidx+1)
        {
            case 1:
                //nothing
                break;
            case 2:
                cout << "copy pitch class LEDs iso->arb" << menuidx << endl;
                theManta.theData.theArbEditor.pitchClassLedArray = theManta.theData.theIsoEditor.pitchClassLedArray;
                break;
            case 3:
                cout << "copy pad LEDs iso->arb" << menuidx << endl;
                theManta.theData.theArbEditor.padLedArray = theManta.theData.theIsoEditor.padLedArray;
                break;
            case 4:
                cout << "copy midi note LEDs iso->arb" << menuidx << endl;
                theManta.theData.theArbEditor.midiNoteLedArray = theManta.theData.theIsoEditor.midiNoteLedArray;
                break;
            case 5:
                cout << "copy all LED settings iso->arb" << menuidx << endl;
                theManta.theData.theArbEditor.pitchClassLedArray = theManta.theData.theIsoEditor.pitchClassLedArray;
                theManta.theData.theArbEditor.padLedArray = theManta.theData.theIsoEditor.padLedArray;
                theManta.theData.theArbEditor.midiNoteLedArray = theManta.theData.theIsoEditor.midiNoteLedArray;
                break;
            default:
                throw std::invalid_argument("edit mode error");
        }
        copyIsoArbBox.setSelectedId(1, dontSendNotification);
        theManta.theData.theArbEditor.refresh();//is this needed?
    }
    
    

}

void MainContentComponent::buttonClicked (Button* but)//should be done with a switch statement?
{
    if (but == &txDownOctBut)
    {
        theManta.theData.transpose (-12);
    }
    else if (but == &txUpOctBut)
    {
        theManta.theData.transpose (12);
    }
    else if (but == &txDownSemiBut)
    {
        theManta.theData.transpose (-1);
        //*theManta.theData.ledMessagePendingPtr = 50;//50 is code for set all from array
    }
    else if (but == &txUpSemiBut)
    {
        theManta.theData.transpose (1);
        //*theManta.theData.ledMessagePendingPtr = 50;//50 is code for set all from array
    }
    else if (but == &panic)
		{
        theManta.theMidiIO.panicButton();//call midiiopanic
        theManta.panic();
		}
    else if (but == &fastVelBut)
        {
            if (theManta.theData.fastVel)
            {
            theManta.theData.fastVel = false;
            fastVelBut.setButtonText("Manta Vel Mode");
            }
            else
            {
            theManta.theData.fastVel = true;
            fastVelBut.setButtonText("Fast Vel Mode");
            }
        cout << "fastVel= " << theManta.theData.fastVel << endl;
        }
    else if (but == &connect)
    {
        
        connect.setToggleState(connectToManta(), dontSendNotification);

    }else if (but == &isoToArbBut)
    {
        theManta.theData.theArbEditor.arbNoteMap = theManta.theData.theIsoEditor.isoNoteMap;
        theManta.theData.theArbEditor.refresh();
    }
    else if (but == &lineGraphBut)
    {
        theManta.theData.editMode = 1;
        cout << "editMode = " << theManta.theData.editMode << endl;
        showEditor();
    }
    else if (but == &freeGraphBut)
    {
        theManta.theData.editMode = 2;
        cout << "editMode = " << theManta.theData.editMode << endl;
        showEditor();
    }
    else if (but == &isoSetBut)
    {
        theManta.theData.editMode = 3;
        cout << "editMode = " << theManta.theData.editMode << endl;
        showEditor();
    }
    else if (but == &arbSetBut)
    {
        theManta.theData.editMode = 4;
        cout << "editMode = " << theManta.theData.editMode << endl;
        showEditor();
    }
    //cout << "button clicked" << endl;
}


void MainContentComponent::loadGuiFromModel()
{
    cout << "refreshing gui from model" << endl;
    
    int index;
    //GLOBALS
    if (theManta.theData.fastVel)
    {
        theManta.theData.fastVel = false;
        fastVelBut.setButtonText("Manta Vel Mode");
    }
    else
    {
        theManta.theData.fastVel = true;
        fastVelBut.setButtonText("Fast Vel Mode");
    }
    
    index = theManta.theData.channel;
    channelBox.setSelectedId(index, dontSendNotification);
    
    index = theManta.theData.pollInterval;
    pollIntervalBox.setSelectedId(index, dontSendNotification);
    
    index = theManta.theData.editMode;
    
    switch(theManta.theData.editMode)
    {
        case 1:
            lineGraphBut.setToggleState(true, dontSendNotification);
            freeGraphBut.setToggleState(false, dontSendNotification);
            isoSetBut.setToggleState(false, dontSendNotification);
            arbSetBut.setToggleState(false, dontSendNotification);
            break;
        case 2:
            lineGraphBut.setToggleState(false, dontSendNotification);
            freeGraphBut.setToggleState(true, dontSendNotification);
            isoSetBut.setToggleState(false, dontSendNotification);
            arbSetBut.setToggleState(false, dontSendNotification);
            break;
        case 3:
            lineGraphBut.setToggleState(false, dontSendNotification);
            freeGraphBut.setToggleState(false, dontSendNotification);
            isoSetBut.setToggleState(true, dontSendNotification);
            arbSetBut.setToggleState(false, dontSendNotification);
            break;
        case 4:
            lineGraphBut.setToggleState(false, dontSendNotification);
            freeGraphBut.setToggleState(false, dontSendNotification);
            isoSetBut.setToggleState(false, dontSendNotification);
            arbSetBut.setToggleState(true, dontSendNotification);
            break;
        default:
            throw std::invalid_argument("edit mode error");
    }
    
    
    //EXPRESSION
    
    index = theManta.theData.thin;//why is this line here?
    thinBox.setSelectedId(index, dontSendNotification);
    //should this be done with enums? float accuracy?
    if (theManta.theData.thin == 0){
		thinBox.setSelectedId(1, dontSendNotification);
	} else if (theManta.theData.thin == 0.2){
		thinBox.setSelectedId(2, dontSendNotification);
	} else if (theManta.theData.thin == 0.5){
		thinBox.setSelectedId(3, dontSendNotification);
	} else if (theManta.theData.thin == 1){
		thinBox.setSelectedId(4, dontSendNotification);
	} else if (theManta.theData.thin == 2){
		thinBox.setSelectedId(5, dontSendNotification);
	} else if (theManta.theData.thin == 4){
		thinBox.setSelectedId(7, dontSendNotification);
	} else if (theManta.theData.thin == 8){
		thinBox.setSelectedId(1, dontSendNotification);
	} else {
		throw std::invalid_argument("thin mode error");
	}
    
    index = theManta.theData.numMultiChannels;
    multiChansBox.setSelectedId(index, dontSendNotification);
    
    index = theManta.theData.expressionMode;
    expressionModeBox.setSelectedId(index, dontSendNotification);
    
    
    switch(theManta.theData.expressionMode)
    {
		case 1:
                //polyafter
                multiChansBox.setEnabled(false);
                ccExpBox.setEnabled(false);
                expOutBox.setEnabled(false);
                break;
        case 2:
                //CC
                multiChansBox.setEnabled(false);
                ccExpBox.setEnabled(true);
                expOutBox.setEnabled(true);
                break;
        case 3:
                //multi mode
                multiChansBox.setEnabled(true);
                ccExpBox.setEnabled(true);
                expOutBox.setEnabled(true);
                break;
        case 4:
                //off
                multiChansBox.setEnabled(false);
                ccExpBox.setEnabled(false);
                expOutBox.setEnabled(false);
                break;
        default:
            throw std::invalid_argument("expression mode error");
    }
    
    switch(theManta.theData.ccToUse)
    {
        case 1:
            index = 1;
            break;
        case 2:
            index = 2;
            break;
        case 3:
            index = 3;
            break;
        case 4:
            index = 4;
            break;
        case 7:
            index = 5;
            break;
        case 10:
            index = 6;
            break;
        case 11:
            index = 7;
            break;
        case -1://-1 is horrible code for channel pressure
            index = 8;
            break;
        default:
            throw std::invalid_argument("CC setting error");
    }
    ccExpBox.setSelectedId(index, dontSendNotification);
    
    
    if (theManta.theData.hirescc){
		index = 2;
	} else {
		index = 1;
	}
    hiresBox.setSelectedId(index, dontSendNotification);
    
    theManta.theMidiIO.expOut=theManta.theData.exprOut;
    if (theManta.theData.exprOut){//data vesrion is prime
		index = 2;
	} else {
		index = 1;
	}
    expOutBox.setSelectedId(index, dontSendNotification);

    
    switch(theManta.theData.slider1CC)
    {
        case 1:
            index = 1;
            break;
        case 2:
            index = 2;
            break;
        case 3:
            index = 3;
            break;
        case 4:
            index = 4;
            break;
        case 7:
            index = 5;
            break;
        case 10:
            index = 6;
            break;
        case 11:
            index = 7;
            break;
        case 5:
            index = 8;
            break;
        default:
            throw std::invalid_argument("CC setting error");
    }
    slider1Box.setSelectedId(index, dontSendNotification);
    
    switch(theManta.theData.slider0CC)
    {
        case 1:
            index = 1;
            break;
        case 2:
            index = 2;
            break;
        case 3:
            index = 3;
            break;
        case 4:
            index = 4;
            break;
        case 7:
            index = 5;
            break;
        case 10:
            index = 6;
            break;
        case 11:
            index = 7;
            break;
       case 5:
            index = 8;
            break;
        default:
            throw std::invalid_argument("CC setting error");
    }
    slider0Box.setSelectedId(index, dontSendNotification);
    
    //ISO TAB
    theManta.theData.theIsoEditor.loadBoxesFromModel();
    //ARB / FREE TAB
    theManta.theData.theArbEditor.loadBoxesFromModel();
    showEditor();//this has to happen last after everything initialised correctly!

 //tabs should all refresh from model when tab selected
    
}


void MainContentComponent::mantaDisconnected()
{
    
    connect.setToggleState(false, dontSendNotification);
    connect.setButtonText("Connect");
    
    helpLabel.setText("The Manta was unexpectedly disconnected", dontSendNotification);
}


bool MainContentComponent::connectToManta()
{
    
    
    
    if (theManta.IsConnected())//toggle to disconnect
    {
        theManta.signalThreadShouldExit();
        connect.setButtonText("Connect");
        helpLabel.setText("Disconnected", dontSendNotification);
        return false;
       
    }
    else //try to connect
    {
        try
        {
            theManta.Connect(0);
        }
        catch (MantaNotFoundException)
        {
            connect.setButtonText("Connect");
            cout << "Could not find an attached Manta." << endl;
            helpLabel.setText("Could not find an attached Manta.", dontSendNotification);

        }

        if (theManta.IsConnected())
        {
            serial = theManta.GetSerialNumber();
            cout << "serial is " << serial << endl;
            connect.setButtonText("Connected to " + String(serial));

            helpLabel.setText("Connected successfully to serial " + String(serial), dontSendNotification);

            theManta.startThread();
            
            
           
            theManta.theData.ledMessagePending = 50;
            
            
            return true;
        } else {
            return false;
        }
    }
    
}
