/*
  ==============================================================================

    LineGraph.cpp
    Created: 17 Sep 2016 11:13:25pm
    Author:  studioone

  ==============================================================================
*/

#include "LineGraph.h"

#include<iostream>//enables c standard output
using namespace std;

//==============================================================================
LineGraph::LineGraph()
{
    
    //lastIndex = -1;
    graphMap.fill(0);
    
    addAndMakeVisible(invertBut);
    invertBut.setButtonText("Invert");
    invertBut.addListener(this);
    invertBut.setTooltip("Invert graph");
    
    
    addAndMakeVisible(flipBut);
    flipBut.setButtonText("Flip");
    flipBut.addListener(this);
    flipBut.setTooltip("Mirror left to right");
    
    addAndMakeVisible(resetBut);
    resetBut.setButtonText("Reset");
    resetBut.addListener(this);
    resetBut.setTooltip("Reset Graph to X=Y");
    
    addAndMakeVisible(posLabel);
    
    //graphTips.setMillisecondsBeforeTipAppears(650);
    
    reset();
    
    //cout << "initialised graphMap " << endl;
    cout << "LineGraph constructed" << endl;
}

LineGraph::~LineGraph()
{
}

void LineGraph::paint (Graphics& g)
{
    nodeRad = (graphWidth/100)+2;
    int nodeDia = nodeRad*2-1;
    g.fillAll (Colours::white);   // clear the background
    
    
    g.setColour (Colours::lightgrey);
    Rectangle<int> butColumn(graphWidth,0,getWidth()-graphWidth,getHeight());
    g.fillRect(butColumn);
    
    g.setColour (Colours::grey);
    g.drawRect (getLocalBounds(), 1);   // draw an outline around the component
    g.drawRect (butColumn, 1);   // draw an outline around the component
    
    
    //auto graphcol = Colour(0.60f,1.0f,1.0f,1.0f);//hue saturation brightness opacity
    auto graphcol = Colour(225,235,255);
    g.setColour (graphcol);//Draw actual array values
    for (int i = 0; i < numInputValues ; i++) {//iterate over array items not pixels!
        //width height
        float left = float(i)*widthscale;
        float top = getHeight()-(graphMap[i]*heightscale);//cast to float shouldnt be needed any more
        //float width = floor(widthscale);
        float width = 2;
        float height = graphMap[i]*heightscale;
        Rectangle<int> column(left,top,width,height);
        g.fillRect(column);
        }
    
    //draw crosshairs
    g.drawLine (0, getHeight()/2, graphWidth, getHeight()/2 );
    g.drawLine (graphWidth/2, 0 , graphWidth/2, getHeight());
    
    ////Draw line graph
    g.setColour (Colours::green);
    for (int i = 0; i < numNodes ; i++) {//iterate through nodes
        Point<float> point = nodeArray[i];
        
        Rectangle<float> square(point.x*widthscale-nodeRad,getHeight()-point.y*heightscale-nodeRad,nodeDia,nodeDia);
        g.fillEllipse(square);
        if (i > 0)
        {
            auto lastpoint = nodeArray[i-1];
            g.drawLine(lastpoint.x*widthscale, getHeight()-lastpoint.y*heightscale, point.x*widthscale, getHeight()-point.y*heightscale, 2);
        }
    }//end node loop

    
}

void LineGraph::resized()
{
    graphWidth = getWidth()*0.8;
    Rectangle<int> temp(0,0,graphWidth,getHeight());
    graphRect = temp;
    
    
    widthscale = float(graphWidth)/float(numInputValues);//dont recalc every time!!
    heightscale = float(getHeight())/float(numOutputValues);//these factors will be greater than 1
    
   
    //reset();
    
    int columnWidth = (getWidth() - graphWidth);
    int buttonWidth = columnWidth*0.8;
    int margin = (columnWidth-buttonWidth)/2;
    int buttonHeight = getHeight()/10;
    //channelBox.setBounds (leftMargin,topMargin,buttonWidth,buttonHeight);
    
    invertBut.setBounds (graphWidth+margin,margin,buttonWidth,buttonHeight);
    flipBut.setBounds (graphWidth+margin,margin*2+buttonHeight,buttonWidth,buttonHeight);
    resetBut.setBounds (graphWidth+margin,margin*3+buttonHeight*2,buttonWidth,buttonHeight);
    
    posLabel.setBounds (graphWidth+margin, margin*4+buttonHeight*3,buttonWidth,buttonHeight);
    posLabel.setJustificationType(Justification::centred);
    //posLabel.setFont(getHeight()*0.03);
    posLabel.setText("pos", dontSendNotification);

}

void LineGraph::buttonClicked (Button* but)
{
    if (but == &invertBut)
    {
        invert();
    }
    else if (but == &flipBut)
    {
        flip();    }
    else if (but == &resetBut)
    {
        reset();
    }
    
}

void LineGraph::reset ()
{
    //RESET MAPPING ARRAY
    for (int i = 0; i < numInputValues; ++i)
    {
        graphMap[i]=i*numOutputValues/numInputValues;
        //numoutputvalues = 1 and should be rebnamed
        //cout << "Linput " << (i) << " = output " << (graphMap[i]) << endl;
    }
    
    //RESET LINEGRAPH NODES
    
    float widthInc = (float)numInputValues/(numNodes-1);
    float heightInc = (float)numOutputValues/(numNodes-1);
    //cout << "widthInc = " << widthInc << endl;
    //cout << "heightInc = " << heightInc << endl;
    
    for (int i = 0; i < numNodes; i++)
    {
        nodeArray[i].x = float(i*widthInc);
        nodeArray[i].y = float(i*heightInc);
    }
    cout << "initialised nodeArray " << endl;
    
    recalcGraphMap();
    
    repaint();
}

void LineGraph::flip ()
{
    auto oldNodeArray = nodeArray;
    
   
    for (int i = 0; i < numNodes; i++)
    {
        nodeArray[i].y = oldNodeArray[numNodes-i-1].y;
        nodeArray[numNodes-i-1].x = (numInputValues-oldNodeArray[i].x);
    }
    
    cout << "flipped nodeArray " << endl;
    
    


    recalcGraphMap();
    repaint();
}

void LineGraph::invert ()
{
    for (int i = 0; i < numNodes; i++)
    {
        nodeArray[i].y = numOutputValues-nodeArray[i].y ;
    }
    cout << "inverted nodeArray " << endl;
    
    recalcGraphMap();
    repaint();
}



void LineGraph::mouseEnter (const MouseEvent& mouse)
{
    
}

void LineGraph::mouseExit (const MouseEvent& mouse)
{
}


int LineGraph::clickInNode (int x, int y)//returns index of clicked node
{
    bool clickisinnode = false;
    int i = 0;
    do
    {//cant use contains since nodearray stores points not shapes
        
        float xposmax = nodeArray[i].x*widthscale + nodeRad;
        float xposmin = nodeArray[i].x*widthscale - nodeRad;
        float yposmax = getHeight()-(nodeArray[i].y*heightscale) + nodeRad;
        float yposmin = getHeight()-(nodeArray[i].y*heightscale) -nodeRad;
        
        
        if ((x > xposmin) && (x < xposmax) && (y > yposmin ) && (y < yposmax))
        {
            clickisinnode = true;
            currentNode = i;
        }
        i++;
        
    } while (!clickisinnode && i<numNodes);
    //cout << "click in node index = " << (currentNode) <<endl;

    if (clickisinnode)
        return i-1;
    else
        return -1;
}

void LineGraph::mouseDown(const MouseEvent& mouse)
{
    dragisMD = true;
    activeNode = false;
    if (clickInNode(mouse.x, mouse.y) != -1)
    {
        activeNode = true;
    }

}

void LineGraph::mouseDoubleClick (const MouseEvent& mouse)
{
    int node = clickInNode(mouse.x, mouse.y);
    auto oldNodeArray = nodeArray;
    //ignore double clicks in end nodes as they shouldnt be deleted
    if ((node > 0) && (node < numNodes-1))//if the double click is in a node, delete it
    {
        //delete node
        cout << "doubleclick in node = " << (node) <<endl;
        
        for (int i = 0; i < numNodes ; i++)
        {
            if (i < node)
            {
            nodeArray[i] = oldNodeArray[i];
            } else if (i > node)
            {
            nodeArray[i-1] = oldNodeArray[i];
            }
            
        }//end delete node loop
        numNodes -= 1;
    }
    else //otherwise create new node
    {
       if (mouse.x < graphWidth && numNodes < maxNumNodes)//check if mouse in graph
        {
            cout << "doubleclick outside node = " << (node) <<endl;
            //add node
            
            numNodes += 1;
            for (int i = 0; i < numNodes-1 ; i++)
            {
                //cout << "index = " << (i) <<endl;
                int currentx = oldNodeArray[i].x*widthscale;
                int nextx = oldNodeArray[i+1].x*widthscale;
                if ((currentx < mouse.x-nodeRad) && (nextx > mouse.x+nodeRad))
                {
                    //cout << "insertnode = " << (i+1) <<endl;
                    nodeArray[i+1].x = mouse.x/widthscale;
                    nodeArray[i+1].y = (getHeight()-mouse.y)/heightscale;
                }
                if (currentx > mouse.x)
                {
                    //shift
                    nodeArray[i+1] = oldNodeArray[i];
                    //cout << "shifted index = " << (i) <<endl;

                }
                if (currentx < mouse.x)
                {
                    //copy
                    nodeArray[i] = oldNodeArray[i];
                    //cout << "copied index = " << (i) <<endl;

                }
            }//end add node loop
            
        }//end if is in graph
    }//end else
    recalcGraphMap();
    repaint();
    
}
void LineGraph::mouseUp (const MouseEvent& mouse)
{
    
    if (activeNode) {
        recalcGraphMap();
        repaint();
    }
    activeNode = false;
    
}

void LineGraph::recalcGraphMap()//rewrite to never contain value less than 1
{
    for (int node = 0; node < numNodes-1; node++)
    {
        
        int x = nodeArray[node].x;
        float y = nodeArray[node].y;
        int nextx = nodeArray[node+1].x;
        float nexty = nodeArray[node+1].y;
        //cout << "x = " << (x) << " y = " << (y) <<  " nextx = " << (nextx) <<  " nexty = " << (nexty) << endl;
        
        int distance = nextx - x;
        float increment = float((nexty - y) /(float)distance);
        //cout << "increment = " << (increment) << " distance = " << (distance) <<endl;
        float value = y;
        int i = x;
        while (i < nextx)
        {
            i += 1;
            value += increment;
            graphMap[i] = value;//no compensation now
            //~ float hires = graphMap[i]*127;
            //~ int rounded = 0.5+graphMap[i]*127;
            //~ int msb = graphMap[i]*127;
            //~ int lsb = (hires-msb)*127;
            //~ cout << "input=" << (i) << " hires=" << hires  << " rounded=" << rounded  << " msb=" << msb  <<" lsb=" << lsb  <<endl;
       
        };
    }

    //cout << "filled graphMap " << endl;
    //cout << "-----------------------------------------------------------------" << endl << endl;
}

int LineGraph::getRealX(int mouseX)//ARE THESE USED??? should be used in mousedrag?
{
    return (int)(mouseX/widthscale);
}

float LineGraph::getRealY(int mouseY)
{
    return (getHeight()-mouseY)/heightscale;
}

void LineGraph::mouseDrag (const MouseEvent& mouse)
{
    auto xstr=String(getRealX(mouse.x));
    auto ystr=String(getRealY(mouse.y));
    
    auto yystr = ystr.substring(0,5);
    
    auto posstring = "In "+xstr+", Out "+yystr;
    posLabel.setText(posstring, dontSendNotification);
    
    float mouseX;
    if (activeNode && !dragisMD)
    {
        if (currentNode == 0)
        {
            mouseX = 0;
        }
        else if (currentNode == numNodes-1)
        {
            mouseX = graphWidth;
        }
        else
        {
            int prevNodeX = nodeArray[(currentNode-1)].x*widthscale;
            int nextNodeX = nodeArray[(currentNode+1)].x*widthscale;
            mouseX = jlimit(prevNodeX , nextNodeX , mouse.x);
        }
        
        float mouseY = jlimit(0,getHeight(),  mouse.y);;
        nodeArray[currentNode].x = mouseX/widthscale;
        nodeArray[currentNode].y = (getHeight()-mouseY)/heightscale;
        //cout << "mouseX = " << mouseX << " mouseY = " << mouseY <<endl;
        
        repaint();
    }
    dragisMD = false;

}
