/*
  ==============================================================================

    IsoEditor.h
    Created: 26 Sep 2016 11:06:12pm
    Author:  studioone

  ==============================================================================
*/

#ifndef ISOEDITOR_H_INCLUDED
#define ISOEDITOR_H_INCLUDED

#include "JuceHeader.h"
#include <array>

class MantaData;//forward declaration

//==============================================================================
/*
*/
class IsoEditor    : public Component,
                    private ComboBox::Listener,
                    private Button::Listener
{
public:
    IsoEditor();
    ~IsoEditor();

    void paint (Graphics&) override;
    void resized() override;
    
    //int transposeOneValue(int value, int transposition);
    void refresh();
    void fillIsoNoteMap();
    
    void loadBoxesFromModel();

    
    String getNoteNameFromNumber(int notenumber);
    int getOctaveFromNumber(int notenumber);

    //ComboBox ledsOrArbNotes;
    
    //bool setNotes = false;

    
    int upLeft = 5;
    int upRight = 7;
    
    // int ledMessagePending = -1;
    
    std::array<int, 50> ledArray;//current settings for each pad in any mode
    std::array<int, 50> padLedArray;//settings for each pad in pad mode
    std::array<int, 14> pitchClassLedArray;// = {2,0,0,2,0,0,1,1,0,0,0,0,0,0};
    //  std::array<Manta::LEDState, 12> noteLEDs = {Manta::Red, Manta::Off, Manta::Off, Manta::Red, Manta::Off, Manta::Off, Manta::Amber ,Manta::Amber, Manta::Off, Manta::Off, Manta::Off, Manta::Off};
    
    std::array<int, 130> midiNoteLedArray;//doesn't automatically intialise to 0 on linux gcc.
    
    //std::array<int, 50> arbNoteMap;
    std::array<int, 50> isoNoteMap;
    // no longer needed std::array<int, 50> *noteMap; //pointer to padnotemap in mantadata
    
    String helpText;
    
    MantaData* theData;
    
    int settingMode = 1;
    
    int redAndYellowLEDs = 0;//0 = both, 1= red only , 2 = none
    
private:
    
    ComboBox upLeftBox;
    ComboBox upRightBox;
    ComboBox ledSetModeBox;//set leds by pitch class, by pad or by note (should this be in the IsoEditor class?)
    ComboBox ledMantaModeBox;
    //TextButton isoToArbBut;
    TextButton clearLEDsBut;
    Label upLeftLabel;
    Label upRightLabel;

    
    void comboBoxChanged (ComboBox* box) override;
    
    
    void buttonClicked (Button* but) override;
    
    
    void mouseDown (const MouseEvent&) override;
    
    void mouseDownLeds (const MouseEvent&);
    void mouseDownNotes (const MouseEvent&);
    
    void setByPitchClass();
    void setByMidiNote();
    void clearLEDs();
    
    int gutter = 3;
    int squishrows = 2;
    int padSize;

    int keyZeroNote = 30;
    
    int arrayWidth;
    std::array<Point<float>, 48> padCentresArray;

    std::array<Path, 48> hexagonArray;
    int clickedPad = -1;
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (IsoEditor)
};


#endif  // IsoEditor_H_INCLUDED
