/*
  ==============================================================================

    IsoEditor.cpp
    Created: 26 Sep 2016 11:06:12pm
    Author:  studioone

  ==============================================================================
*/

//#include "../modules/JuceHeader.h"
#include "IsoEditor.h"
#include "MantaData.h"


#include<iostream>//enables c standard output
using namespace std;

//==============================================================================
IsoEditor::IsoEditor()
{
    //arbNoteMap.fill(55);//gcc requires explicit initialisations!
    
    midiNoteLedArray.fill(0);
    ledArray.fill(0);
    padLedArray.fill(0);
    pitchClassLedArray = {2,0,0,2,0,0,1,1,0,0,0,0};
    
    //isoNoteMap.fill(0);
    
    
    addAndMakeVisible(upLeftBox);
    upLeftBox.setTooltip("Defines the isomorphic layout by setting the interval in semitones from any pad to the one on its upper left.");
    addAndMakeVisible(upRightBox);
    upRightBox.setTooltip("Defines the isomorphic layout by setting the interval in semitones from any pad to the one on its upper right.");
    //string sign = "+";
    int j = 1;
    for (int i = 12; i > -13; --i)
    {
        upLeftBox.addItem(String(i), j);
        upRightBox.addItem(String(i), j);
        j++;
    }
    upLeftBox.addListener(this);
    upLeftBox.setSelectedId(8, dontSendNotification);
    upRightBox.addListener(this);
    upRightBox.setSelectedId(6, dontSendNotification);
    upLeft = 5; upRight = 7;
    
    addAndMakeVisible(upLeftLabel);
    addAndMakeVisible(upRightLabel);

    upLeftLabel.setText("Up Left", dontSendNotification);
    upRightLabel.setText("Up Right", dontSendNotification);

    //fillIsoNoteMap();//has to be done from data since not initilaised yet

    
    addAndMakeVisible(clearLEDsBut);
    clearLEDsBut.setButtonText("Clear");
    clearLEDsBut.addListener(this);
    clearLEDsBut.setTooltip("turn all LEDs off in current layout mode (no undo)");
    
    
    addAndMakeVisible(ledSetModeBox);
    ledSetModeBox.setTooltip("Set and track LEDs by pad , note or pitch class");
    ledSetModeBox.addItem ("LEDs by Pitch Class", 1);
    ledSetModeBox.addItem ("LEDs by Pad", 2);
    ledSetModeBox.addItem ("LEDs by Midi Note number", 3);
    ledSetModeBox.addListener(this);
    ledSetModeBox.setSelectedId(1, dontSendNotification);
    
    
    addAndMakeVisible(ledMantaModeBox);
    ledMantaModeBox.setTooltip("Manta LED mode - affects leds sent to Manta, not those set/stored on computer ");
    ledMantaModeBox.addItem ("Red and Yellow", 1);
    ledMantaModeBox.addItem ("Red Only (yellow on touch)", 2);
    ledMantaModeBox.addItem ("yellow on touch only", 3);
    ledMantaModeBox.addListener(this);
    ledMantaModeBox.setSelectedId(1, dontSendNotification);
    
    
    //(*theData).ledMessagePending = 50;//50 is code for set all from array
    
    cout << "IsoEditor constructed" << endl;
    
}

IsoEditor::~IsoEditor()
{
}

void IsoEditor::paint (Graphics& g)
{
    //cout << "IsoEditor repaint called" << endl;
    
    g.fillAll(Colours::lightgrey);
    
    g.setColour (Colours::grey);
    g.drawRect (getLocalBounds(), 1);   // draw an outline around the component
   
    int row = 0;
    int offset = 0;
    
    auto textcol = (Colours::lightgrey);
    auto yellowpad = (Colours::gold);
    auto redpad = (Colours::red);
    
    String notename;
    int octave;
    
    for (int i = 0; i <= 47 ; i++)
    {
        row = floor(i/8);
        //cout << "row = " << (row) << endl;
        //cout << "pad = " << (i) << endl;
        if (row%2 == 1)
        {
            offset = padSize/2;
        } else {
            offset = 0;
        }
        
        Point<float> centre;
        centre.x = gutter+(i%8)*padSize+offset+padSize/2;
        centre.y = getHeight()-gutter-(row*(padSize-squishrows))-padSize/2;
        padCentresArray[i] = centre;

        
        Path outlineHexagon;
        outlineHexagon.addPolygon(centre, 6, padSize/2+1);
        g.setColour (Colours::black);
        g.fillPath(outlineHexagon);
        Path hexagon;
        hexagon.addPolygon(centre, 6, padSize/2);
        hexagonArray[i] = hexagon;
        
        switch(ledArray[i])
        {
            case 0:
                g.setColour (Colours::grey);
                break;
            case 1:
                g.setColour (yellowpad);
                break;
            case 2:
                g.setColour (redpad);
                break;
            default:
                throw std::invalid_argument("invalid pad colour");
        }
        g.fillPath(hexagon);
        
        g.setColour (textcol);
        
      
        notename =  getNoteNameFromNumber((isoNoteMap)[i]);
        octave = getOctaveFromNumber((isoNoteMap)[i]);
            //cout << "notename = " << notename << endl;
        
        
        g.setFont(padSize*0.45);
        g.drawText(notename + String(octave), centre.x-padSize/2, centre.y-padSize/2,padSize,padSize,juce::Justification::centred);
        
        
    }
}


void IsoEditor::resized()
{
    
    gutter = 3;
    squishrows = 2;
    int height = getHeight()-gutter*2;
    padSize = height/6+squishrows;
    int width = getWidth()*0.8;
    int padSizeWidth = width/8.5;
    
    if (padSizeWidth < padSize)
        padSize = padSizeWidth;
    arrayWidth = padSize*8+padSize/2;//ARG put most of this in resized
    
    float rowHeight = getHeight()/9;
    float margin = rowHeight/3;
    float leftMargin = arrayWidth + margin;
    
    float buttonHeight = rowHeight-margin/2;
    float buttonWidth = getWidth()-arrayWidth-margin*2;
    upLeftLabel.setBounds (leftMargin,margin,buttonWidth/2,buttonHeight);
    upRightLabel.setBounds (leftMargin+buttonWidth/2,margin,buttonWidth/2,buttonHeight);
    upLeftBox.setBounds (leftMargin,margin+rowHeight,buttonWidth/3,buttonHeight);
    upRightBox.setBounds (leftMargin+buttonWidth/2,margin+rowHeight,buttonWidth/3,buttonHeight);
    
    
    ledSetModeBox.setBounds (leftMargin,margin+rowHeight*2,buttonWidth,buttonHeight);//left top width height
    
    ledMantaModeBox.setBounds (leftMargin,margin+rowHeight*3,buttonWidth,buttonHeight);
    
    clearLEDsBut.setBounds (leftMargin,margin+rowHeight*4,buttonWidth,buttonHeight);
    
    

    //(*theData).ledMessagePending = 50;
}


void IsoEditor::mouseDown (const MouseEvent& mouse)
{
        mouseDownLeds(mouse);
}


void IsoEditor::mouseDownLeds (const MouseEvent& mouse)
{
    int mouseflag = mouse.mods.getRawFlags();
    if ( mouse.mods.isRightButtonDown())
    {
        cout << "right click  " << endl;
    }
    cout << "mouseflag " << mouseflag << endl;

    
    bool foundPad = false;
    clickedPad = -1;
    int i = 0;
    do
    {
        if (hexagonArray[i].contains(mouse.x, mouse.y))
        {
            foundPad = true;
            clickedPad = i;
            cout << "clicked pad " << (i) << endl;
        }
        i++;
        
    } while (!foundPad && i<48);

    
    if (clickedPad != -1)
    {
        switch(settingMode)
        {
            case 1://set leds by pitch class
            {
                int midinote = (isoNoteMap)[clickedPad];
                cout << "midinote " << midinote << endl;
                int pitchClass = (int)((midinote+3)%12);
                cout << "pitchClass " << pitchClass << endl;
                int prevvalue = pitchClassLedArray[pitchClass];
                
                int newvalue = (prevvalue+1)%3;
                pitchClassLedArray[pitchClass] = newvalue;
                setByPitchClass();
                (*theData).ledMessagePending = 50;
                cout << "clicked pad " << (i) << endl;
                
            }
                break;
            case 2://set leds by pad
            {
                (*theData).ledMessagePending = clickedPad;
                padLedArray[clickedPad] = (padLedArray[clickedPad]+1)%3;
                ledArray[clickedPad] = padLedArray[clickedPad];
            }
                break;
            case 3://set leds by midi note number
            {
                int midinote = (isoNoteMap)[clickedPad];
                cout << "midinote " << midinote << endl;
                int prevvalue = midiNoteLedArray[midinote];
                
                int newvalue = (prevvalue+1)%3;
                midiNoteLedArray[midinote] = newvalue;
                setByMidiNote();
                (*theData).ledMessagePending = 50;
                cout << "clicked pad " << (i) << endl;
            }
                break;
            default:
                throw std::invalid_argument("invalid ledsetting Mode");
        }//end switch
        
        //repaint();
    }//end if
    repaint();
}

void IsoEditor::setByPitchClass()
{
    for (int i = 0; i < 48; ++i)
    {
        int midinote = (isoNoteMap)[i];
        int pitchClass = (int)((midinote+3)%12);
        int colour = pitchClassLedArray[pitchClass];
        ledArray[i] = colour;
    }
}

String IsoEditor::getNoteNameFromNumber(int notenumber)
{
    int pitchClass = (int)((notenumber+3)%12);
    String notename;
    switch (pitchClass)
    {
        case 0:
            notename = "A";
            break;
        case 1:
            notename = "Bb";
            break;
        case 2:
            notename = "B";
            break;
        case 3:
            notename = "C";
            break;
        case 4:
            notename = "C#";
            break;
        case 5:
            notename = "D";
            break;
        case 6:
            notename = "Eb";
            break;
        case 7:
            notename = "E";
            break;
        case 8:
            notename = "F";
            break;
        case 9:
            notename = "F#";
            break;
        case 10:
            notename = "G";
            break;
        case 11:
            notename = "G#";
            break;
        default:
            notename = "-";
    }
    return notename;
}

int IsoEditor::getOctaveFromNumber(int notenumber)
{
    //int pitchClass = (int)((notenumber+3)%12);
    int octave = (int)((notenumber+3)/12);
    return octave;
}


void IsoEditor::setByMidiNote()
{
    for (int i = 0; i < 48; ++i)
    {
        int midinote = (isoNoteMap)[i];
        int colour = midiNoteLedArray[midinote];
        ledArray[i] = colour;
    }
}

void IsoEditor::clearLEDs()
{
    switch(settingMode)
    {
        case 1://clear leds by pitch class
        {
            pitchClassLedArray.fill(0);
        }
            break;
        case 2://clear leds by pad
        {
            padLedArray.fill(0);//no need to update the array
        }
            break;
        case 3://clear leds by midi note number
        {
            midiNoteLedArray.fill(0);
        }
            break;
        default:
            throw std::invalid_argument("invalid ledsetting Mode");
    }//end switch
    //ledArray.fill(0);
    refresh();
}

void IsoEditor::refresh()
{
    
    cout << "iso refresh called "<< endl;
    
    switch(settingMode)
    {
        case 1://set leds by pitch class
        {
            setByPitchClass();
        }
            break;
        case 2://set leds by pad
        {
            ledArray = padLedArray;//no need to update the array
        }
            break;
        case 3://set leds by midi note number
        {
             setByMidiNote();
        }
            break;
        default:
            throw std::invalid_argument("invalid ledsetting Mode");
    }//end switch
    
    (*theData).ledMessagePending = 50;
    
    const MessageManagerLock mmLock;//if this is called from any manta callback method however far upstream then it is on the manta thread and the message manager thread needs to be locked.
    
    repaint();
}

void IsoEditor::loadBoxesFromModel()
{
    
    int index = ((upLeft -12)*-1)+1;
    upLeftBox.setSelectedId(index, dontSendNotification);
    
    cout << "index= " << index << "  upleft= " << upLeft<< endl;
    index = ((upRight -12)*-1)+1;
    upRightBox.setSelectedId(index, dontSendNotification);
    
    index = settingMode;
    ledSetModeBox.setSelectedId(index, dontSendNotification);
    cout << "settingMode from file =" << settingMode << endl;
    cout << "settingModeBox index =" << index << endl;
    
    index = 1+redAndYellowLEDs;
    ledMantaModeBox.setSelectedId(index, dontSendNotification);
    cout << "redAndYellowLEDs from file =" << redAndYellowLEDs << endl;
    cout << "redAndYellowLEDs index =" << index << endl;
    
}



void IsoEditor::comboBoxChanged (ComboBox* box){
    int menuidx;
    
    if (box == &upLeftBox)
    {
        menuidx = (upLeftBox.getSelectedItemIndex());
        upLeft = (menuidx * -1) + 12;
        cout << "upLeft= " << upLeft << endl;
        fillIsoNoteMap();
    }
    else if (box == &upRightBox)
    {
        menuidx = (upRightBox.getSelectedItemIndex());
        upRight = (menuidx * -1) + 12;
        cout << "upRight= " << upRight << endl;
        fillIsoNoteMap();
    }
    else if (box == &ledSetModeBox)
    {
        menuidx = (ledSetModeBox.getSelectedItemIndex());
        settingMode = menuidx+1;
        (*theData).ledMessagePending = 50;//50 is code for set all from array

        cout << "settingMode " << settingMode << endl;
    }
    else if (box == &ledMantaModeBox)
    {
        menuidx = (ledMantaModeBox.getSelectedItemIndex());
        
        redAndYellowLEDs = menuidx;//yes it should be an enum not an int
    }
    
    refresh();
    
}


void IsoEditor::buttonClicked (Button* but)//should be done with a switch statement?
{
    //no iso to arb copy button in iso mode???
   if (but == &clearLEDsBut)
   {
        clearLEDs();
    }
        //cout << "button clicked" << endl;
}

void IsoEditor::fillIsoNoteMap()
{
    
    //blank the array first for debugging
    isoNoteMap.fill(0);

    const int rowLength = 8;//manta has 8 keys per row
    const int numRows = 6;//manta has 6 rows
    
    //cout << "upLeft " << upLeft << " upRight " << upRight << endl;
    //keyZeroNote = 32;
    int rightInterval = upRight-upLeft;
    isoNoteMap[1]= keyZeroNote;
    
    int keynum = 0;//first pad on Manta is pad 0
    isoNoteMap[keynum] = keyZeroNote;
    int nextRowIncrement= upRight;
    
    for (int row = 0; row < numRows; ++row)//so easy to get out by one!
    {
        for (int i = 1; i < rowLength; ++i){//fill row
            isoNoteMap[keynum+1]=isoNoteMap[keynum]+rightInterval;//fill the rest of the row
            //int value = padToNoteMap.at(keynum+1);
            //cout << keynum << " = " << value << endl;
            keynum++;
        }//end fill row
        if (row < numRows-1)
        {
            if (row%2 == 0) nextRowIncrement = upRight; else nextRowIncrement = upLeft;//is it an odd or evenrow, even rows veer right
            //if (row == 1 || row == 3 || row == 5 || row == 8 || row == 10 || row == 12) nextRowIncrement = upLeft;else nextRowIncrement = upRight;//axis stupid version
            isoNoteMap[keynum+1] = isoNoteMap.at(keynum-(rowLength-1))+nextRowIncrement; //move up a row //OUT OF RANGE LAST TIME
            //int value = padToNoteMap.at(keynum+1);
            //cout << keynum << " = " << value << endl;
            keynum++;
        }
        
    }
    refresh();
}
