/*
  ==============================================================================

    ArbEditor.h
    Created: 16 Nov 2016 11:25:06pm
    Author:  studioone

  ==============================================================================
*/

#ifndef ARBEDITOR_H_INCLUDED
#define ARBEDITOR_H_INCLUDED

#include "JuceHeader.h"
#include <array>
class MantaData;//forward declaration

//==============================================================================
/*
*/
class ArbEditor    : public Component,
                            private ComboBox::Listener,
                            private Button::Listener
{
public:
    ArbEditor();
    ~ArbEditor();

    void paint (Graphics&) override;
    void resized() override;
    
    int transposeOneValue(int value, int transposition);
    void refresh();
    void loadBoxesFromModel();

    String getNoteNameFromNumber(int notenumber);
    int getOctaveFromNumber(int notenumber);
    
    //int ledMessagePending = -1;
    
    std::array<int, 50> ledArray;//current settings for each pad in any mode
    
    std::array<int, 50> padLedArray;//settings for each pad in pad mode
    std::array<int, 14> pitchClassLedArray;// = {2,0,0,2,0,0,1,1,0,0,0,0,0,0};
    //  std::array<Manta::LEDState, 12> noteLEDs = {Manta::Red, Manta::Off, Manta::Off, Manta::Red, Manta::Off, Manta::Off, Manta::Amber ,Manta::Amber, Manta::Off, Manta::Off, Manta::Off, Manta::Off};
    
    std::array<int, 130> midiNoteLedArray;//doesn't automatically intialise to 0 on linux gcc.
    
    std::array<int, 50> arbNoteMap;
    
    String helpText;
    
    MantaData* theData;
    
    int settingMode = 1;
    
    int redAndYellowLEDs = 0;//0 = both, 1= red only , 2 = none
    
    
private:
    
    ComboBox ledSetModeBox;//set leds by pitch class, by pad or by note (should this be in the lededitor class?)
    ComboBox ledMantaModeBox;
  
    Label arbHelpLabel;
    
    TextButton clearLEDsBut;
    
    void comboBoxChanged (ComboBox* box) override;
    void buttonClicked (Button* but) override;
    
    
    void mouseDown (const MouseEvent&) override;
    
    void mouseDownLeds (const MouseEvent&);
    void mouseDownNotes (const MouseEvent&);
    
    void setByPitchClass();
    void setByMidiNote();
    void clearLEDs();
    
    int gutter = 3;
    int squishrows = 2;
    int padSize;
    
    
    int arrayWidth;
    std::array<Point<float>, 48> padCentresArray;
    
    std::array<Path, 48> hexagonArray;
    int clickedPad = -1;
    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (ArbEditor)
};


#endif  // ArbEditor_H_INCLUDED
