/*
  ==============================================================================

    ArbEditor.cpp
    Created: 16 Nov 2016 11:25:06pm
    Author:  studioone

  ==============================================================================
*/

//#include "../modules/JuceHeader.h"
#include "ArbEditor.h"
#include "MantaData.h"


#include<iostream>//enables c standard output
using namespace std;

//==============================================================================
ArbEditor::ArbEditor()
{
    //arbNoteMap.fill(55);//gcc requires explicit initialisations!
    arbNoteMap = {42,44,46,48,50,52,54,56, 43,45,47,49,51,53,55,57, 49,51,53,55,57,59,61,63, 50,52,54,56,58,60,62,64, 56,58,60,62,64,66,68,70, 57,59,61,63,65,67,69,71, 0, 0};
    midiNoteLedArray.fill(0);//should arbnote mode actually have separate led settings too?
    ledArray.fill(0);
    padLedArray.fill(0);
    pitchClassLedArray = {2,0,0,2,0,0,1,1,0,0,0,0};
    /*
    addAndMakeVisible(isoToArbBut);
    isoToArbBut.setButtonText("Copy Iso->Free");
    isoToArbBut.addListener(this);
    isoToArbBut.setTooltip("copy the currect iso note layout to the arbitrary layout");
    */
    addAndMakeVisible(clearLEDsBut);
    clearLEDsBut.setButtonText("Clear");
    clearLEDsBut.addListener(this);
    clearLEDsBut.setTooltip("turn all LEDs off in current layout mode (no undo)");
    
    addAndMakeVisible(ledSetModeBox);
    ledSetModeBox.setTooltip("Set and track LEDs by pad , note or pitch class");
    ledSetModeBox.addItem ("LEDs by Pitch Class", 1);
    ledSetModeBox.addItem ("LEDs by Pad", 2);
    ledSetModeBox.addItem ("LEDs by Midi Note", 3);
    ledSetModeBox.addListener(this);
    ledSetModeBox.setSelectedId(1, dontSendNotification);
    
    addAndMakeVisible(ledMantaModeBox);
    ledMantaModeBox.setTooltip("Manta LED mode - affects leds sent to Manta, not those set/stored on computer ");
    ledMantaModeBox.addItem ("Red and Yellow", 1);
    ledMantaModeBox.addItem ("Red Only (yellow on touch)", 2);
    ledMantaModeBox.addItem ("yellow on touch only", 3);
    ledMantaModeBox.addListener(this);
    ledMantaModeBox.setSelectedId(1, dontSendNotification);
    
    addAndMakeVisible(arbHelpLabel);
    arbHelpLabel.setText("Left click to change LEDs. Use upper or lower half of each pad to raise / lower pitch. Right Click for semitones, middle or shift click for 8ves", dontSendNotification);
    
    cout << "ArbEditor constructed" << endl;}

ArbEditor::~ArbEditor()
{
}

void ArbEditor::paint (Graphics& g)
{
    //cout << "ArbEditor repaint called" << endl;
    
    g.fillAll(Colours::lightgrey);
    
    g.setColour (Colours::grey);
    g.drawRect (getLocalBounds(), 1);   // draw an outline around the component
    
    int row = 0;
    int offset = 0;
    
  
    auto textcol = (Colours::white);
    auto yellowpad = (Colours::goldenrod);
    auto redpad = (Colours::indianred);
    
    
    String notename;
    int octave;
    
    for (int i = 0; i <= 47 ; i++)
    {
        row = floor(i/8);
        //cout << "row = " << (row) << endl;
        //cout << "pad = " << (i) << endl;
        if (row%2 == 1)
        {
            offset = padSize/2;
        } else {
            offset = 0;
        }
        
        Point<float> centre;
        centre.x = gutter+(i%8)*padSize+offset+padSize/2;
        centre.y = getHeight()-gutter-(row*(padSize-squishrows))-padSize/2;
        padCentresArray[i] = centre;
        
        
        Path outlineHexagon;
        outlineHexagon.addPolygon(centre, 6, padSize/2+1);
        g.setColour (Colours::black);
        g.fillPath(outlineHexagon);
        Path hexagon;
        hexagon.addPolygon(centre, 6, padSize/2);
        hexagonArray[i] = hexagon;
        
        switch(ledArray[i])
        {
            case 0:
                g.setColour (Colours::grey);
                break;
            case 1:
                g.setColour (yellowpad);
                break;
            case 2:
                g.setColour (redpad);
                break;
            default:
                throw std::invalid_argument("invalid pad colour");
        }
        g.fillPath(hexagon);
        
        g.setColour (textcol);
        
        notename =  getNoteNameFromNumber((arbNoteMap)[i]);
        octave = getOctaveFromNumber((arbNoteMap)[i]);
        
        
        g.setFont(padSize*0.45);
        g.drawText(notename + String(octave), centre.x-padSize/2, centre.y-padSize/2,padSize,padSize,juce::Justification::centred);
        
        
    }
}

void ArbEditor::resized()
{
    gutter = 3;
    squishrows = 2;
    int height = getHeight()-gutter*2;
    padSize = height/6+squishrows;
    int width = getWidth()*0.8;
    int padSizeWidth = width/8.5;
    
    if (padSizeWidth < padSize)
        padSize = padSizeWidth;
    arrayWidth = padSize*8+padSize/2;//ARG put most of this in resized
    
    
    
    
    float rowHeight = getHeight()/9;
    float margin = rowHeight/3;
    float leftMargin = arrayWidth + margin;
    
    float buttonHeight = rowHeight-margin/2;
    float buttonWidth = getWidth()-arrayWidth-margin*2;
    
    ledSetModeBox.setBounds (leftMargin,margin,buttonWidth,buttonHeight);//left top width height
    
    ledMantaModeBox.setBounds (leftMargin,margin+rowHeight,buttonWidth,buttonHeight);
    
    //isoToArbBut.setBounds (leftMargin,margin+rowHeight*2,buttonWidth,buttonHeight);
    
    clearLEDsBut.setBounds (leftMargin,margin+rowHeight*2,buttonWidth,buttonHeight);
    
    arbHelpLabel.setBounds (leftMargin,margin+rowHeight*4,buttonWidth,buttonHeight*5);
    
    (*theData).ledMessagePending = 50;
    
}


void ArbEditor::mouseDown (const MouseEvent& mouse)
{//left click = set leds //right click +/- semi shift click or middle click +-8ves
    if ( (mouse.mods.isRightButtonDown()) || (mouse.mods.isShiftDown()) || (mouse.mods.isMiddleButtonDown()) )
    {
        mouseDownNotes(mouse);
    }
    else if (mouse.mods.isLeftButtonDown())
        
    {
        mouseDownLeds(mouse);
    
    }
}


void ArbEditor::mouseDownNotes (const MouseEvent& mouse)
{
    
    
        bool upperHalf = false;
        
        bool foundPad = false;
        clickedPad = -1;
        int i = 0;
        do
        {
            if (hexagonArray[i].contains(mouse.x, mouse.y))
            {
                foundPad = true;
                clickedPad = i;
                cout << "clicked pad " << (i) << endl;
                if (mouse.y < padCentresArray[i].y)
                    upperHalf = true;
            }
            i++;
            
        } while (!foundPad && i<48);
        
        //right button is semis, middle or shift is 8ves
        if (upperHalf)
        {
            if ((mouse.mods.isShiftDown()) || (mouse.mods.isMiddleButtonDown()))
            {
                arbNoteMap[clickedPad]=transposeOneValue(arbNoteMap[clickedPad], 12);
            } else {
                arbNoteMap[clickedPad]=transposeOneValue(arbNoteMap[clickedPad], 1);
            }
        }//end upperhalf
        else //assume lowerhalf
        {
            if ((mouse.mods.isShiftDown()) || (mouse.mods.isMiddleButtonDown()))
            {
                arbNoteMap[clickedPad]=transposeOneValue(arbNoteMap[clickedPad], -12);
            } else {//rightbutton
                arbNoteMap[clickedPad]=transposeOneValue(arbNoteMap[clickedPad], -1);
            }
        }//end lowerhalf
        
        refresh();
    
    
}


int ArbEditor::transposeOneValue (int value, int transposition)
{
    int newValue;
    
    newValue = value+transposition;
    if (newValue > 127)
        newValue = value;
    else if (newValue < 0)
        newValue = value;
    cout << "newvalue " << newValue << endl;
    return newValue;
    
}

void ArbEditor::mouseDownLeds (const MouseEvent& mouse)
{//this should only be called when left button with no shift
    
    bool foundPad = false;
    clickedPad = -1;
    int i = 0;
    do
    {
        if (hexagonArray[i].contains(mouse.x, mouse.y))
        {
            foundPad = true;
            clickedPad = i;
            cout << "clicked pad " << (i) << endl;
        }
        i++;
        
    } while (!foundPad && i<48);
    
    
    if (clickedPad != -1)
    {
        switch(settingMode)
        {
            case 1://set leds by pitch class
            {
                int midinote = (arbNoteMap)[clickedPad];
                cout << "midinote " << midinote << endl;
                int pitchClass = (int)((midinote+3)%12);
                cout << "pitchClass " << pitchClass << endl;
                int prevvalue = pitchClassLedArray[pitchClass];
                
                int newvalue = (prevvalue+1)%3;
                pitchClassLedArray[pitchClass] = newvalue;
                setByPitchClass();
                (*theData).ledMessagePending = 50;
                cout << "clicked pad " << (i) << endl;
                
            }
                break;
            case 2://set leds by pad
            {
                (*theData).ledMessagePending = clickedPad;
                padLedArray[clickedPad] = (padLedArray[clickedPad]+1)%3;
                ledArray[clickedPad] = padLedArray[clickedPad];
            }
                break;
            case 3://set leds by midi note number
            {
                int midinote = (arbNoteMap)[clickedPad];
                cout << "midinote " << midinote << endl;
                int prevvalue = midiNoteLedArray[midinote];
                
                int newvalue = (prevvalue+1)%3;
                midiNoteLedArray[midinote] = newvalue;
                setByMidiNote();
                (*theData).ledMessagePending = 50;
                cout << "clicked pad " << (i) << endl;
            }
                break;
            default:
                throw std::invalid_argument("invalid ledsetting Mode");
        }//end switch
        
        //repaint();
    }//end if
    repaint();
}

void ArbEditor::setByPitchClass()
{
    for (int i = 0; i < 48; ++i)
    {
        int midinote = (arbNoteMap)[i];
        int pitchClass = (int)((midinote+3)%12);
        int colour = pitchClassLedArray[pitchClass];
        ledArray[i] = colour;
    }
}

String ArbEditor::getNoteNameFromNumber(int notenumber)
{
    int pitchClass = (int)((notenumber+3)%12);
    String notename;
    switch (pitchClass)
    {
        case 0:
            notename = "A";
            break;
        case 1:
            notename = "Bb";
            break;
        case 2:
            notename = "B";
            break;
        case 3:
            notename = "C";
            break;
        case 4:
            notename = "C#";
            break;
        case 5:
            notename = "D";
            break;
        case 6:
            notename = "Eb";
            break;
        case 7:
            notename = "E";
            break;
        case 8:
            notename = "F";
            break;
        case 9:
            notename = "F#";
            break;
        case 10:
            notename = "G";
            break;
        case 11:
            notename = "G#";
            break;
        default:
            notename = "-";
    }
    return notename;
}

int ArbEditor::getOctaveFromNumber(int notenumber)
{
    //int pitchClass = (int)((notenumber+3)%12);
    int octave = (int)((notenumber+3)/12);
    return octave;
}


void ArbEditor::setByMidiNote()
{
    for (int i = 0; i < 48; ++i)
    {
        int midinote = (arbNoteMap)[i];
        int colour = midiNoteLedArray[midinote];
        ledArray[i] = colour;
    }
}

void ArbEditor::clearLEDs()
{
    switch(settingMode)
    {
        case 1://clear leds by pitch class
        {
            pitchClassLedArray.fill(0);
        }
            break;
        case 2://clear leds by pad
        {
            padLedArray.fill(0);//no need to update the array
        }
            break;
        case 3://clear leds by midi note number
        {
            midiNoteLedArray.fill(0);
        }
            break;
        default:
            throw std::invalid_argument("invalid ledsetting Mode");
    }//end switch
    //ledArray.fill(0);
    refresh();
}

void ArbEditor::refresh()
{
    cout << "arb refresh called "<< endl;
    switch(settingMode)
    {
        case 1://set leds by pitch class
        {
            setByPitchClass();
        }
            break;
        case 2://set leds by pad
        {
            ledArray = padLedArray;
        }
            break;
        case 3://set leds by midi note number
        {
            setByMidiNote();
        }
            break;
        default:
            throw std::invalid_argument("invalid ledsetting Mode");
    }//end switch
    
    (*theData).ledMessagePending = 50;
    
    const MessageManagerLock mmLock;//if repaint is called from any manta callback method however far upstream then it is on the manta thread and the message manager thread needs to be locked.
    
    repaint();
}

void ArbEditor::loadBoxesFromModel()
{
    int index = settingMode;
    ledSetModeBox.setSelectedId(index, dontSendNotification);
    cout << "settingMode from file =" << settingMode << endl;
    cout << "settingModeBox index =" << index << endl;
    
    
    index = 1+redAndYellowLEDs;
    ledMantaModeBox.setSelectedId(index, dontSendNotification);
    cout << "redAndYellowLEDs from file =" << redAndYellowLEDs << endl;
    cout << "redAndYellowLEDs index =" << index << endl;
    
}

void ArbEditor::comboBoxChanged (ComboBox* box){
    int menuidx;
    if (box == &ledSetModeBox)
    {
        menuidx = (ledSetModeBox.getSelectedItemIndex());
        settingMode = menuidx+1;
        (*theData).ledMessagePending = 50;//50 is code for set all from array
        
        cout << "settingMode " << settingMode << endl;
    }
    else if (box == &ledMantaModeBox)
    {
        menuidx = (ledMantaModeBox.getSelectedItemIndex());
        
        redAndYellowLEDs = menuidx;//yes it should be an enum not an int
    }
    
    refresh();
    
}


void ArbEditor::buttonClicked (Button* but)//should be done with a switch statement?
{
    /*if (but == &isoToArbBut)
    {
        arbNoteMap = (*theData).theIsoEditor.isoNoteMap;
        refresh();
    } else */
    if (but == &clearLEDsBut){
        clearLEDs();
    }
    
    //cout << "button clicked" << endl;
}
